/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.action.impl.BreakfallReady;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.PacketDirection;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class StartBreakfallMessage {
    UUID playerID = null;
    boolean justTimed = false;

    public UUID getPlayerID() {
        return this.playerID;
    }

    public void encode(PacketBuffer packet) {
        packet.writeLong(this.playerID.getMostSignificantBits());
        packet.writeLong(this.playerID.getLeastSignificantBits());
        packet.writeBoolean(this.justTimed);
    }

    public static StartBreakfallMessage decode(PacketBuffer packet) {
        StartBreakfallMessage message = new StartBreakfallMessage();
        message.playerID = new UUID(packet.readLong(), packet.readLong());
        message.justTimed = packet.readBoolean();
        return message;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)contextSupplier.get()).getNetworkManager().getDirection() == PacketDirection.CLIENTBOUND) {
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (player == null) {
                    return;
                }
                if (!this.playerID.equals(player.func_110124_au())) {
                    return;
                }
                Parkourability parkourability = Parkourability.get((PlayerEntity)player);
                if (parkourability == null) {
                    return;
                }
                IStamina stamina = IStamina.get((PlayerEntity)player);
                if (stamina == null) {
                    return;
                }
                parkourability.get(BreakfallReady.class).startBreakfall((PlayerEntity)player, parkourability, stamina, this.justTimed);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void handleServer(Supplier<NetworkEvent.Context> contextSupplier) {
    }

    public static void send(ServerPlayerEntity player, boolean justTimed) {
        StartBreakfallMessage message = new StartBreakfallMessage();
        message.playerID = player.func_110124_au();
        message.justTimed = justTimed;
        ParCool.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }
}

