/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.api.unstable.action.ParCoolActionEvent;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.Parkourability;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class SyncActionStateMessage {
    private UUID senderUUID = null;
    private byte[] buffer = null;

    private SyncActionStateMessage() {
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeLong(this.senderUUID.getMostSignificantBits()).writeLong(this.senderUUID.getLeastSignificantBits()).writeInt(this.buffer.length).writeBytes(this.buffer);
    }

    public static SyncActionStateMessage decode(PacketBuffer packetBuffer) {
        SyncActionStateMessage message = new SyncActionStateMessage();
        message.senderUUID = new UUID(packetBuffer.readLong(), packetBuffer.readLong());
        int size = packetBuffer.readInt();
        message.buffer = new byte[size];
        packetBuffer.readBytes(message.buffer);
        return message;
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void handleServer(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)this);
            if (player == null) {
                return;
            }
            Parkourability parkourability = Parkourability.get((PlayerEntity)player);
            if (parkourability == null) {
                return;
            }
            Decoder decoder = new Decoder(this.buffer, parkourability);
            while (decoder.hasNext()) {
                ActionSyncData item = decoder.getItem();
                if (item == null) continue;
                Action action = item.getAction();
                switch (item.getType()) {
                    case Start: {
                        action.setDoing(true);
                        action.onStartInServer((PlayerEntity)player, parkourability, item.getBuffer());
                        action.onStart((PlayerEntity)player, parkourability);
                        MinecraftForge.EVENT_BUS.post((Event)new ParCoolActionEvent.StartEvent((PlayerEntity)player, action));
                        break;
                    }
                    case Finish: {
                        action.setDoing(false);
                        action.onStopInServer((PlayerEntity)player);
                        action.onStop((PlayerEntity)player);
                        MinecraftForge.EVENT_BUS.post((Event)new ParCoolActionEvent.StopEvent((PlayerEntity)player, action));
                        break;
                    }
                    case Normal: {
                        action.restoreSynchronizedState(item.getBuffer());
                    }
                }
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            boolean clientSide;
            ServerPlayerEntity player;
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                if (world == null) {
                    return;
                }
                player = world.func_217371_b(this.senderUUID);
                if (player == null || player.func_175144_cb()) {
                    return;
                }
                clientSide = true;
            } else {
                player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
                ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)this);
                if (player == null) {
                    return;
                }
                clientSide = false;
            }
            Parkourability parkourability = Parkourability.get((PlayerEntity)player);
            if (parkourability == null) {
                return;
            }
            Decoder decoder = new Decoder(this.buffer, parkourability);
            while (decoder.hasNext()) {
                ActionSyncData item = decoder.getItem();
                if (item == null) continue;
                Action action = item.getAction();
                switch (item.getType()) {
                    case Start: {
                        action.setDoing(true);
                        if (clientSide) {
                            action.onStartInOtherClient((PlayerEntity)player, parkourability, item.getBuffer());
                        } else {
                            action.onStartInServer((PlayerEntity)player, parkourability, item.getBuffer());
                        }
                        action.onStart((PlayerEntity)player, parkourability);
                        MinecraftForge.EVENT_BUS.post((Event)new ParCoolActionEvent.StartEvent((PlayerEntity)player, action));
                        break;
                    }
                    case Finish: {
                        action.setDoing(false);
                        if (clientSide) {
                            action.onStopInOtherClient((PlayerEntity)player);
                        } else {
                            action.onStopInServer((PlayerEntity)player);
                        }
                        action.onStop((PlayerEntity)player);
                        MinecraftForge.EVENT_BUS.post((Event)new ParCoolActionEvent.StopEvent((PlayerEntity)player, action));
                        break;
                    }
                    case Normal: {
                        action.restoreSynchronizedState(item.getBuffer());
                    }
                }
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sync(PlayerEntity player, Encoder builder) {
        ByteBuffer buffer1 = builder.build();
        if (buffer1.limit() == 0) {
            return;
        }
        SyncActionStateMessage message = new SyncActionStateMessage();
        message.senderUUID = player.func_110124_au();
        message.buffer = new byte[buffer1.limit()];
        buffer1.get(message.buffer);
        ParCool.CHANNEL_INSTANCE.sendToServer((Object)message);
    }

    private static class ActionSyncData {
        Action action;
        ByteBuffer buffer;
        DataType type;

        public ActionSyncData(Action action, ByteBuffer buffer, DataType type) {
            this.action = action;
            this.buffer = buffer;
            this.type = type;
        }

        public DataType getType() {
            return this.type;
        }

        public Action getAction() {
            return this.action;
        }

        public ByteBuffer getBuffer() {
            return this.buffer;
        }
    }

    private static enum DataType {
        Normal,
        Start,
        Finish;


        public byte getCode() {
            return (byte)this.ordinal();
        }

        public static DataType getFromCode(byte code) {
            return DataType.values()[code];
        }
    }

    private static class Decoder {
        ByteBuffer buffer;
        Parkourability parkourability;

        Decoder(byte[] buf, Parkourability parkourability) {
            this.buffer = ByteBuffer.wrap(buf).asReadOnlyBuffer();
            this.parkourability = parkourability;
        }

        public boolean hasNext() {
            return this.buffer.position() < this.buffer.limit();
        }

        @Nullable
        public ActionSyncData getItem() {
            Action action = this.parkourability.getActionFromID(this.buffer.getShort());
            DataType type = DataType.getFromCode(this.buffer.get());
            int bufferSize = this.buffer.getInt();
            if (bufferSize > 1024) {
                StringBuilder msgBuilder = new StringBuilder();
                msgBuilder.append("Synchronization failed. demanded buffer size is too large\n").append(action).append(":Sync_Type").append((Object)type).append('\n').append(this.buffer);
                if (this.buffer.limit() < 128) {
                    this.buffer.rewind();
                    msgBuilder.append("->{");
                    while (this.buffer.hasRemaining()) {
                        msgBuilder.append(Integer.toHexString(this.buffer.get())).append(',');
                    }
                    msgBuilder.append('}');
                }
                ParCool.LOGGER.warn(msgBuilder.toString());
                this.buffer.position(this.buffer.limit());
                return null;
            }
            ByteBuffer buf = this.buffer.slice();
            buf.limit(bufferSize);
            this.buffer.position(this.buffer.position() + bufferSize);
            if (action == null) {
                return null;
            }
            return new ActionSyncData(action, buf, type);
        }
    }

    public static class Encoder {
        private static final Encoder instance = new Encoder();
        private final ByteBuffer buffer = ByteBuffer.allocate(1024);

        private Encoder() {
        }

        public static Encoder reset() {
            Encoder.instance.buffer.clear();
            return instance;
        }

        public Encoder appendSyncData(Parkourability parkourability, Action action, ByteBuffer actionBuffer) {
            return this.append(DataType.Normal, parkourability, action, actionBuffer);
        }

        public Encoder appendStartData(Parkourability parkourability, Action action, ByteBuffer actionBuffer) {
            return this.append(DataType.Start, parkourability, action, actionBuffer);
        }

        public Encoder appendFinishMsg(Parkourability parkourability, Action action) {
            short id = parkourability.getActionID(action);
            if (id < 0) {
                return this;
            }
            this.buffer.putShort(id).put(DataType.Finish.getCode()).putInt(0);
            return this;
        }

        private Encoder append(DataType type, Parkourability parkourability, Action action, ByteBuffer actionBuffer) {
            short id = parkourability.getActionID(action);
            if (id < 0) {
                return this;
            }
            this.buffer.putShort(id).put(type.getCode()).putInt(actionBuffer.limit()).put(actionBuffer);
            return this;
        }

        public ByteBuffer build() {
            this.buffer.flip();
            return this.buffer;
        }
    }
}

