/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ClientSetting;
import com.alrex.parcool.server.limitation.Limitations;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class SyncClientInformationMessage {
    private final ByteBuffer data = ByteBuffer.allocate(512);
    private UUID playerID = null;
    private boolean requestLimitations = false;

    public void encode(PacketBuffer packet) {
        packet.writeLong(this.playerID.getMostSignificantBits());
        packet.writeLong(this.playerID.getLeastSignificantBits());
        packet.writeBoolean(this.requestLimitations);
        packet.writeBytes(this.data);
        this.data.rewind();
    }

    public static SyncClientInformationMessage decode(PacketBuffer packet) {
        SyncClientInformationMessage message = new SyncClientInformationMessage();
        message.playerID = new UUID(packet.readLong(), packet.readLong());
        message.requestLimitations = packet.readBoolean();
        while (packet.isReadable()) {
            message.data.put(packet.readByte());
        }
        message.data.flip();
        return message;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            Parkourability parkourability;
            ServerPlayerEntity player;
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                if (world == null) {
                    return;
                }
                player = world.func_217371_b(this.playerID);
                if (player == null) {
                    return;
                }
            } else {
                ServerPlayerEntity serverPlayer = ((NetworkEvent.Context)contextSupplier.get()).getSender();
                player = serverPlayer;
                if (player == null) {
                    return;
                }
                ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)this);
                if (this.requestLimitations) {
                    Limitations.update(serverPlayer);
                }
            }
            if ((parkourability = Parkourability.get((PlayerEntity)player)) == null) {
                return;
            }
            if (!player.func_175144_cb()) {
                parkourability.getActionInfo().setClientSetting(ClientSetting.readFrom(this.data));
                this.data.rewind();
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    public void handleServer(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (player == null) {
                return;
            }
            ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)this);
            Parkourability parkourability = Parkourability.get((PlayerEntity)player);
            if (parkourability == null) {
                return;
            }
            if (this.requestLimitations) {
                Limitations.update(player);
            }
            parkourability.getActionInfo().setClientSetting(ClientSetting.readFrom(this.data));
            this.data.rewind();
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sync(ClientPlayerEntity player, boolean requestSendLimitation) {
        Parkourability parkourability = Parkourability.get((PlayerEntity)player);
        if (parkourability == null) {
            return;
        }
        SyncClientInformationMessage message = new SyncClientInformationMessage();
        parkourability.getClientInfo().writeTo(message.data);
        message.data.flip();
        message.playerID = player.func_110124_au();
        message.requestLimitations = requestSendLimitation;
        ParCool.CHANNEL_INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)message);
    }
}

