/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.stamina.OtherStamina;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class SyncStaminaMessage {
    private int stamina = 0;
    private int max = 0;
    private boolean exhausted = false;
    private int consumeOnServer = 0;
    private int staminaType = -1;
    private UUID playerID = null;

    public void encode(PacketBuffer packet) {
        packet.writeInt(this.stamina);
        packet.writeInt(this.max);
        packet.writeBoolean(this.exhausted);
        packet.writeInt(this.staminaType);
        packet.writeInt(this.consumeOnServer);
        packet.writeLong(this.playerID.getMostSignificantBits());
        packet.writeLong(this.playerID.getLeastSignificantBits());
    }

    public static SyncStaminaMessage decode(PacketBuffer packet) {
        SyncStaminaMessage message = new SyncStaminaMessage();
        message.stamina = packet.readInt();
        message.max = packet.readInt();
        message.exhausted = packet.readBoolean();
        message.staminaType = packet.readInt();
        message.consumeOnServer = packet.readInt();
        message.playerID = new UUID(packet.readLong(), packet.readLong());
        return message;
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void handleServer(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)this);
            if (player == null) {
                return;
            }
            IStamina stamina = IStamina.get((PlayerEntity)player);
            if (stamina == null) {
                return;
            }
            if (stamina instanceof OtherStamina) {
                ((OtherStamina)stamina).setMax(this.max);
            }
            if (this.staminaType != -1 && this.consumeOnServer > 0) {
                IStamina.Type.values()[this.staminaType].handleConsumeOnServer(player, this.consumeOnServer);
            }
            stamina.set(this.stamina);
            stamina.setExhaustion(this.exhausted);
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            IStamina stamina;
            ServerPlayerEntity player;
            ServerPlayerEntity serverPlayer = null;
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                if (world == null) {
                    return;
                }
                player = world.func_217371_b(this.playerID);
                if (player == null || player.func_175144_cb()) {
                    return;
                }
            } else {
                player = serverPlayer = ((NetworkEvent.Context)contextSupplier.get()).getSender();
                ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)this);
                if (player == null) {
                    return;
                }
            }
            if ((stamina = IStamina.get((PlayerEntity)player)) == null) {
                return;
            }
            if (stamina instanceof OtherStamina) {
                ((OtherStamina)stamina).setMax(this.max);
            }
            if (serverPlayer != null && this.staminaType != -1 && this.consumeOnServer > 0) {
                IStamina.Type.values()[this.staminaType].handleConsumeOnServer(serverPlayer, this.consumeOnServer);
            }
            stamina.set(this.stamina);
            stamina.setExhaustion(this.exhausted);
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sync(PlayerEntity player) {
        IStamina stamina = IStamina.get(player);
        if (stamina == null || !player.func_175144_cb()) {
            return;
        }
        SyncStaminaMessage message = new SyncStaminaMessage();
        message.stamina = stamina.get();
        message.max = stamina.getActualMaxStamina();
        message.exhausted = stamina.isExhausted();
        message.consumeOnServer = stamina.getRequestedValueConsumedOnServer();
        IStamina.Type type = IStamina.Type.getFromInstance(stamina);
        message.staminaType = type != null ? type.ordinal() : -1;
        message.playerID = player.func_110124_au();
        ParCool.CHANNEL_INSTANCE.sendToServer((Object)message);
    }
}

