/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.potion;

import com.alrex.parcool.common.potion.Potions;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class ParCoolBrewingRecipe
implements IBrewingRecipe {
    private static final List<MixRecipe> MIXES;

    @Nullable
    private static Potion mix(ItemStack input, ItemStack ingredient) {
        Potion inputPotion = PotionUtils.func_185191_c((ItemStack)input);
        Item ingredientItem = ingredient.func_77973_b();
        for (MixRecipe recipe : MIXES) {
            if (recipe.from.get() != inputPotion || recipe.ingredient.get() != ingredientItem) continue;
            return (Potion)recipe.result.get();
        }
        return null;
    }

    private static boolean isPotionIngredient(Item item) {
        return MIXES.stream().anyMatch(it -> item == ((MixRecipe)it).ingredient.get());
    }

    public boolean isInput(ItemStack input) {
        Item item = input.func_77973_b();
        return item == Items.field_151068_bn || item == Items.field_185155_bH || item == Items.field_185156_bI;
    }

    public boolean isIngredient(ItemStack ingredient) {
        Item item = ingredient.func_77973_b();
        return ParCoolBrewingRecipe.isPotionIngredient(item);
    }

    @Nonnull
    public ItemStack getOutput(ItemStack input, @Nonnull ItemStack ingredient) {
        Potion result;
        if (!input.func_190926_b() && !ingredient.func_190926_b() && this.isIngredient(ingredient) && (result = ParCoolBrewingRecipe.mix(input, ingredient)) != null) {
            return PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)input.func_77973_b()), (Potion)result);
        }
        return ItemStack.field_190927_a;
    }

    static {
        MixRecipe[] mixRecipeArray = new MixRecipe[4];
        mixRecipeArray[0] = new MixRecipe(() -> net.minecraft.potion.Potions.field_185233_e, () -> Items.field_151170_bI, () -> Potions.POOR_ENERGY_DRINK.get());
        mixRecipeArray[1] = new MixRecipe(() -> net.minecraft.potion.Potions.field_185233_e, () -> Items.field_151076_bf, () -> Potions.POOR_ENERGY_DRINK.get());
        mixRecipeArray[2] = new MixRecipe(() -> Potions.POOR_ENERGY_DRINK.get(), () -> Items.field_151128_bU, () -> Potions.ENERGY_DRINK.get());
        mixRecipeArray[3] = new MixRecipe(() -> net.minecraft.potion.Potions.field_185233_e, () -> Items.field_151128_bU, () -> Potions.ENERGY_DRINK.get());
        MIXES = Arrays.asList(mixRecipeArray);
    }

    private static class MixRecipe {
        private final Supplier<Potion> from;
        private final Supplier<Item> ingredient;
        private final Supplier<Potion> result;

        MixRecipe(Supplier<Potion> from, Supplier<Item> ingredient, Supplier<Potion> result) {
            this.from = from;
            this.ingredient = ingredient;
            this.result = result;
        }
    }
}

