/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.mixin.common;

import com.alrex.parcool.common.action.impl.ChargeJump;
import com.alrex.parcool.common.action.impl.ClimbPoles;
import com.alrex.parcool.common.action.impl.ClimbUp;
import com.alrex.parcool.common.capability.Parkourability;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    public abstract BlockState func_213339_cH();

    @Shadow
    public abstract void func_70037_a(CompoundNBT var1);

    @Shadow
    public abstract void func_184597_cx();

    public LivingEntityMixin(EntityType<?> p_i48580_1_, World p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    @Inject(method={"Lnet/minecraft/entity/LivingEntity;onClimbable()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void onClimbable(CallbackInfoReturnable<Boolean> cir) {
        if (this.func_175149_v()) {
            cir.setReturnValue((Object)false);
        } else {
            LivingEntity entity = (LivingEntity)this;
            if (!(entity instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)entity;
            Parkourability parkourability = Parkourability.get(player);
            if (parkourability == null) {
                return;
            }
            if (!parkourability.getActionInfo().can(ClimbPoles.class)) {
                return;
            }
            if (parkourability.get(ClimbUp.class).isDoing()) {
                return;
            }
            ChargeJump chargeJump = parkourability.get(ChargeJump.class);
            if (chargeJump.isDoing() || chargeJump.isCharging()) {
                return;
            }
            BlockPos blockpos = this.func_233580_cy_();
            BlockState blockstate = this.func_213339_cH();
            boolean onLadder = this.parCool$isLivingOnCustomLadder(blockstate, entity.field_70170_p, blockpos, entity);
            if (onLadder) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Unique
    public boolean parCool$isLivingOnCustomLadder(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull LivingEntity entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof PlayerEntity && entity.func_175149_v();
        if (isSpectator) {
            return false;
        }
        if (!((Boolean)ForgeConfig.SERVER.fullBoundingBoxLadders.get()).booleanValue()) {
            return this.parCool$isCustomLadder(state, world, pos, entity);
        }
        AxisAlignedBB bb = entity.func_174813_aQ();
        int mX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int mY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int mZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        int y2 = mY;
        while ((double)y2 < bb.field_72337_e) {
            int x2 = mX;
            while ((double)x2 < bb.field_72336_d) {
                int z2 = mZ;
                while ((double)z2 < bb.field_72334_f) {
                    BlockPos tmp = new BlockPos(x2, y2, z2);
                    if (!world.func_195588_v(pos)) {
                        return false;
                    }
                    state = world.func_180495_p(tmp);
                    if (this.parCool$isCustomLadder(state, world, tmp, entity)) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    @Unique
    private boolean parCool$isCustomLadder(BlockState state, World world, BlockPos pos, LivingEntity entity) {
        Block block = state.getBlockState().func_177230_c();
        if (block instanceof FourWayBlock) {
            boolean stacked;
            int zCount = 0;
            int xCount = 0;
            if (((Boolean)state.func_177229_b((Property)FourWayBlock.field_196409_a)).booleanValue()) {
                ++zCount;
            }
            if (((Boolean)state.func_177229_b((Property)FourWayBlock.field_196413_c)).booleanValue()) {
                ++zCount;
            }
            if (((Boolean)state.func_177229_b((Property)FourWayBlock.field_196411_b)).booleanValue()) {
                ++xCount;
            }
            if (((Boolean)state.func_177229_b((Property)FourWayBlock.field_196414_y)).booleanValue()) {
                ++xCount;
            }
            boolean bl = stacked = world.func_195588_v(pos.func_177984_a()) && world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof FourWayBlock;
            if (!stacked && world.func_195588_v(pos.func_177977_b()) && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof FourWayBlock) {
                stacked = true;
            }
            return (zCount + xCount <= 1 || zCount == 1 && xCount == 1) && stacked;
        }
        if (block instanceof RotatedPillarBlock) {
            boolean stacked;
            boolean bl = stacked = world.func_195588_v(pos.func_177984_a()) && world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof RotatedPillarBlock;
            if (!stacked && world.func_195588_v(pos.func_177977_b()) && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof RotatedPillarBlock) {
                stacked = true;
            }
            return !state.func_235785_r_((IBlockReader)world, pos) && ((Direction.Axis)state.func_177229_b((Property)RotatedPillarBlock.field_176298_M)).func_200128_b();
        }
        if (block instanceof DirectionalBlock) {
            Direction direction = (Direction)state.func_177229_b((Property)DirectionalBlock.field_176387_N);
            return !state.func_235785_r_((IBlockReader)world, pos) && (direction == Direction.UP || direction == Direction.DOWN);
        }
        return false;
    }
}

