/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.server.command.impl;

import com.alrex.parcool.api.unstable.Limitation;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.ActionList;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.server.command.args.ActionArgumentType;
import com.alrex.parcool.server.command.args.LimitationIDArgumentType;
import com.alrex.parcool.server.command.args.LimitationItemArgumentType;
import com.alrex.parcool.server.limitation.Limitations;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ControlLimitationCommand {
    private static final String ARGS_NAME_PLAYERS = "targets";
    private static final String ARGS_NAME_PLAYER = "target";
    private static final String ARGS_NAME_ACTION = "action";
    private static final String ARGS_NAME_STAMINA_CONSUMPTION = "stamina_consumption";
    private static final String ARGS_NAME_POSSIBILITY = "possibility";
    private static final String ARGS_NAME_VALUE = "value";
    private static final String ARGS_NAME_CONFIG_ITEM = "limitation_name";
    private static final String ARGS_NAME_LIMITATION_ID = "limitation_id";

    private static ArgumentBuilder<CommandSource, ?> limitationGetCoreCommands(ArgumentBuilder<CommandSource, ?> builder, boolean hasID, boolean hasPlayer) {
        return builder.then(Commands.func_197057_a((String)"boolean").then(Commands.func_197056_a((String)ARGS_NAME_CONFIG_ITEM, (ArgumentType)LimitationItemArgumentType.booleans()).executes(context -> ControlLimitationCommand.getBoolLimitation((CommandContext<CommandSource>)context, hasID, hasPlayer)))).then(Commands.func_197057_a((String)"integer").then(Commands.func_197056_a((String)ARGS_NAME_CONFIG_ITEM, (ArgumentType)LimitationItemArgumentType.integers()).executes(context -> ControlLimitationCommand.getIntLimitation((CommandContext<CommandSource>)context, hasID, hasPlayer)))).then(Commands.func_197057_a((String)"reals").then(Commands.func_197056_a((String)ARGS_NAME_CONFIG_ITEM, (ArgumentType)LimitationItemArgumentType.doubles()).executes(context -> ControlLimitationCommand.getDoubleLimitation((CommandContext<CommandSource>)context, hasID, hasPlayer)))).then(Commands.func_197057_a((String)ARGS_NAME_POSSIBILITY).then(Commands.func_197056_a((String)ARGS_NAME_ACTION, (ArgumentType)ActionArgumentType.action()).executes(context -> ControlLimitationCommand.getActionPossibility((CommandContext<CommandSource>)context, hasID, hasPlayer)))).then(Commands.func_197057_a((String)"least_stamina_consumption").then(Commands.func_197056_a((String)ARGS_NAME_ACTION, (ArgumentType)ActionArgumentType.action()).executes(context -> ControlLimitationCommand.getLeastStaminaConsumption((CommandContext<CommandSource>)context, hasID, hasPlayer))));
    }

    private static ArgumentBuilder<CommandSource, ?> limitationSetCoreCommands(ArgumentBuilder<CommandSource, ?> builder, boolean hasID, boolean hasPlayer) {
        return builder.then(Commands.func_197057_a((String)"to_default").executes(context -> ControlLimitationCommand.setLimitationDefault((CommandContext<CommandSource>)context, hasID, hasPlayer))).then(Commands.func_197057_a((String)"boolean").then(Commands.func_197056_a((String)ARGS_NAME_CONFIG_ITEM, (ArgumentType)LimitationItemArgumentType.booleans()).then(Commands.func_197056_a((String)ARGS_NAME_VALUE, (ArgumentType)BoolArgumentType.bool()).executes(context -> ControlLimitationCommand.setBoolLimitation((CommandContext<CommandSource>)context, hasID, hasPlayer))))).then(Commands.func_197057_a((String)"integer").then(Commands.func_197056_a((String)ARGS_NAME_CONFIG_ITEM, (ArgumentType)LimitationItemArgumentType.integers()).then(Commands.func_197056_a((String)ARGS_NAME_VALUE, (ArgumentType)IntegerArgumentType.integer()).executes(context -> ControlLimitationCommand.setIntLimitation((CommandContext<CommandSource>)context, hasID, hasPlayer))))).then(Commands.func_197057_a((String)"reals").then(Commands.func_197056_a((String)ARGS_NAME_CONFIG_ITEM, (ArgumentType)LimitationItemArgumentType.doubles()).then(Commands.func_197056_a((String)ARGS_NAME_VALUE, (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> ControlLimitationCommand.setDoubleLimitation((CommandContext<CommandSource>)context, hasID, hasPlayer))))).then(Commands.func_197057_a((String)ARGS_NAME_POSSIBILITY).then(Commands.func_197056_a((String)ARGS_NAME_ACTION, (ArgumentType)ActionArgumentType.action()).then(Commands.func_197056_a((String)ARGS_NAME_POSSIBILITY, (ArgumentType)BoolArgumentType.bool()).executes(context -> ControlLimitationCommand.changePossibilityOfAction((CommandContext<CommandSource>)context, hasID, hasPlayer))))).then(Commands.func_197057_a((String)"least_stamina_consumption").then(Commands.func_197056_a((String)ARGS_NAME_ACTION, (ArgumentType)ActionArgumentType.action()).then(Commands.func_197056_a((String)ARGS_NAME_STAMINA_CONSUMPTION, (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(context -> ControlLimitationCommand.changeStaminaConsumption((CommandContext<CommandSource>)context, hasID, hasPlayer)))));
    }

    private static ArgumentBuilder<CommandSource, ?> getLimitationByNameCommands(boolean multiPlayer, Function<RequiredArgumentBuilder<CommandSource, ?>, ArgumentBuilder<CommandSource, ?>> afterCommand) {
        if (multiPlayer) {
            return Commands.func_197056_a((String)ARGS_NAME_LIMITATION_ID, (ArgumentType)LimitationIDArgumentType.limitation()).then(Commands.func_197057_a((String)"of").then(afterCommand.apply(Commands.func_197056_a((String)ARGS_NAME_PLAYERS, (ArgumentType)EntityArgument.func_197094_d()))));
        }
        return Commands.func_197056_a((String)ARGS_NAME_LIMITATION_ID, (ArgumentType)LimitationIDArgumentType.limitation()).then(Commands.func_197057_a((String)"of").then(afterCommand.apply(Commands.func_197056_a((String)ARGS_NAME_PLAYER, (ArgumentType)EntityArgument.func_197096_c()))));
    }

    private static ArgumentBuilder<CommandSource, ?> getIndividualLimitationCommands(boolean multiPlayer, Function<RequiredArgumentBuilder<CommandSource, ?>, ArgumentBuilder<CommandSource, ?>> afterCommand) {
        if (multiPlayer) {
            return Commands.func_197057_a((String)"individual").then(Commands.func_197057_a((String)"of").then(afterCommand.apply(Commands.func_197056_a((String)ARGS_NAME_PLAYERS, (ArgumentType)EntityArgument.func_197094_d()))));
        }
        return Commands.func_197057_a((String)"individual").then(Commands.func_197057_a((String)"of").then(afterCommand.apply(Commands.func_197056_a((String)ARGS_NAME_PLAYER, (ArgumentType)EntityArgument.func_197096_c()))));
    }

    private static ArgumentBuilder<CommandSource, ?> getGlobalLimitationCommands(Function<LiteralArgumentBuilder<CommandSource>, ArgumentBuilder<CommandSource, ?>> afterCommand) {
        return afterCommand.apply((LiteralArgumentBuilder<CommandSource>)Commands.func_197057_a((String)"global"));
    }

    public static ArgumentBuilder<CommandSource, ?> getBuilder() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"limitation").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"get").then(ControlLimitationCommand.getLimitationByNameCommands(false, it -> {
            it.executes(context -> ControlLimitationCommand.getLimitationInfo((CommandContext<CommandSource>)context, true, true));
            ControlLimitationCommand.limitationGetCoreCommands(it, true, true);
            return it;
        }))).then(ControlLimitationCommand.getIndividualLimitationCommands(false, it -> {
            it.executes(context -> ControlLimitationCommand.getLimitationInfo((CommandContext<CommandSource>)context, false, true));
            ControlLimitationCommand.limitationGetCoreCommands(it, false, true);
            return it;
        }))).then(ControlLimitationCommand.getGlobalLimitationCommands(it -> {
            it.executes(context -> ControlLimitationCommand.getLimitationInfo((CommandContext<CommandSource>)context, false, false));
            ControlLimitationCommand.limitationGetCoreCommands(it, false, false);
            return it;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").requires(commandSource -> commandSource.func_197034_c(2))).then(ControlLimitationCommand.getLimitationByNameCommands(true, it -> {
            ControlLimitationCommand.limitationSetCoreCommands(it, true, true);
            return it;
        }))).then(ControlLimitationCommand.getIndividualLimitationCommands(true, it -> {
            ControlLimitationCommand.limitationSetCoreCommands(it, false, true);
            return it;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"enable").requires(commandSource -> commandSource.func_197034_c(2))).then(ControlLimitationCommand.getLimitationByNameCommands(true, it -> {
            it.executes(context -> ControlLimitationCommand.enableLimitation((CommandContext<CommandSource>)context, true, true));
            return it;
        }))).then(ControlLimitationCommand.getIndividualLimitationCommands(true, it -> {
            ((RequiredArgumentBuilder)it.requires(commandSource -> commandSource.func_197034_c(2))).executes(context -> ControlLimitationCommand.enableLimitation((CommandContext<CommandSource>)context, false, true));
            return it;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"disable").requires(commandSource -> commandSource.func_197034_c(2))).then(ControlLimitationCommand.getLimitationByNameCommands(true, it -> {
            it.executes(context -> ControlLimitationCommand.disableLimitation((CommandContext<CommandSource>)context, true, true));
            return it;
        }))).then(ControlLimitationCommand.getIndividualLimitationCommands(true, it -> {
            it.executes(context -> ControlLimitationCommand.disableLimitation((CommandContext<CommandSource>)context, false, true));
            return it;
        })))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"delete").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197056_a((String)ARGS_NAME_LIMITATION_ID, (ArgumentType)LimitationIDArgumentType.limitation()).executes(ControlLimitationCommand::deleteLimitation)));
    }

    private static List<Limitation> getLimitationInstance(Collection<ServerPlayerEntity> players, @Nullable Limitation.ID id, @Nullable MinecraftServer server) {
        if (players.isEmpty()) {
            if (server != null) {
                return Collections.singletonList(Limitation.getGlobal(server));
            }
            if (id == null) {
                // empty if block
            }
        } else {
            if (id != null) {
                LinkedList<Limitation> list = new LinkedList<Limitation>();
                for (ServerPlayerEntity player : players) {
                    list.add(Limitation.get(player, id));
                }
                return list;
            }
            LinkedList<Limitation> list = new LinkedList<Limitation>();
            for (ServerPlayerEntity player : players) {
                list.add(Limitation.getIndividual(player));
            }
            return list;
        }
        return Collections.emptyList();
    }

    private static int getBoolLimitation(CommandContext<CommandSource> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? Collections.singletonList(EntityArgument.func_197089_d(context, (String)ARGS_NAME_PLAYER)) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSource)context.getSource()).func_197028_i());
        ParCoolConfig.Server.Booleans item = LimitationItemArgumentType.getBool(context, ARGS_NAME_CONFIG_ITEM);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(Boolean.toString(limitations.get(0).get(item))), false);
        return 0;
    }

    private static int getIntLimitation(CommandContext<CommandSource> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? Collections.singletonList(EntityArgument.func_197089_d(context, (String)ARGS_NAME_PLAYER)) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSource)context.getSource()).func_197028_i());
        ParCoolConfig.Server.Integers item = LimitationItemArgumentType.getInt(context, ARGS_NAME_CONFIG_ITEM);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(Integer.toString(limitations.get(0).get(item))), false);
        return 0;
    }

    private static int getDoubleLimitation(CommandContext<CommandSource> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? Collections.singletonList(EntityArgument.func_197089_d(context, (String)ARGS_NAME_PLAYER)) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSource)context.getSource()).func_197028_i());
        ParCoolConfig.Server.Doubles item = LimitationItemArgumentType.getDouble(context, ARGS_NAME_CONFIG_ITEM);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(Double.toString(limitations.get(0).get(item))), false);
        return 0;
    }

    private static int getActionPossibility(CommandContext<CommandSource> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? Collections.singletonList(EntityArgument.func_197089_d(context, (String)ARGS_NAME_PLAYER)) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSource)context.getSource()).func_197028_i());
        Class<? extends Action> action = ActionArgumentType.getAction(context, ARGS_NAME_ACTION);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(Boolean.toString(limitations.get(0).isPermitted(action))), false);
        return 0;
    }

    private static int getLimitationInfo(CommandContext<CommandSource> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? Collections.singletonList(EntityArgument.func_197089_d(context, (String)ARGS_NAME_PLAYER)) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSource)context.getSource()).func_197028_i());
        Limitation limitation = limitations.get(0);
        StringBuilder builder = new StringBuilder();
        builder.append("- Limitation Info -\n");
        builder.append("Enabled : ").append(limitation.isEnabled()).append('\n');
        for (Class<? extends Action> action : ActionList.ACTIONS) {
            builder.append("  ").append(action.getSimpleName()).append(" : ").append('\n').append("    ").append("permitted : ").append(limitation.isPermitted(action)).append('\n').append("    ").append("stamina consumption : ").append(limitation.getLeastStaminaConsumption(action)).append('\n');
        }
        for (ParCoolConfig.Server.Booleans booleans : ParCoolConfig.Server.Booleans.values()) {
            builder.append("  ").append(booleans.getPath()).append(" : ").append(limitation.get(booleans)).append('\n');
        }
        for (Enum enum_ : ParCoolConfig.Server.Integers.values()) {
            builder.append("  ").append(((ParCoolConfig.Server.Integers)enum_).getPath()).append(" : ").append(limitation.get((ParCoolConfig.Server.Integers)enum_)).append('\n');
        }
        for (Enum enum_ : ParCoolConfig.Server.Doubles.values()) {
            builder.append("  ").append(((ParCoolConfig.Server.Doubles)enum_).getPath()).append(" : ").append(limitation.get((ParCoolConfig.Server.Doubles)enum_)).append('\n');
        }
        builder.append("----------");
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(builder.toString()), false);
        return 0;
    }

    private static int getLeastStaminaConsumption(CommandContext<CommandSource> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? Collections.singletonList(EntityArgument.func_197089_d(context, (String)ARGS_NAME_PLAYER)) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSource)context.getSource()).func_197028_i());
        Class<? extends Action> action = ActionArgumentType.getAction(context, ARGS_NAME_ACTION);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(Integer.toString(limitations.get(0).getLeastStaminaConsumption(action))), false);
        return 0;
    }

    private static int setLimitationDefault(CommandContext<CommandSource> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.func_197090_e(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSource)context.getSource()).func_197028_i());
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.setDefault().apply();
            ++num;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("parcool.command.message.success.setLimitationToDefault", new Object[]{num}), true);
        return 0;
    }

    private static int setBoolLimitation(CommandContext<CommandSource> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.func_197090_e(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSource)context.getSource()).func_197028_i());
        ParCoolConfig.Server.Booleans item = LimitationItemArgumentType.getBool(context, ARGS_NAME_CONFIG_ITEM);
        boolean value = BoolArgumentType.getBool(context, (String)ARGS_NAME_VALUE);
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.set(item, value).apply();
            ++num;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("parcool.command.message.success.set", new Object[]{num, item.getPath(), Boolean.toString(value)}), true);
        return 0;
    }

    private static int setIntLimitation(CommandContext<CommandSource> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.func_197090_e(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSource)context.getSource()).func_197028_i());
        ParCoolConfig.Server.Integers item = LimitationItemArgumentType.getInt(context, ARGS_NAME_CONFIG_ITEM);
        int value = IntegerArgumentType.getInteger(context, (String)ARGS_NAME_VALUE);
        if (value < item.Min) {
            value = item.Min;
        }
        if (value > item.Max) {
            value = item.Max;
        }
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.set(item, value).apply();
            ++num;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("parcool.command.message.success.set", new Object[]{num, item.getPath(), Integer.toString(value)}), true);
        return 0;
    }

    private static int setDoubleLimitation(CommandContext<CommandSource> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.func_197090_e(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSource)context.getSource()).func_197028_i());
        ParCoolConfig.Server.Doubles item = LimitationItemArgumentType.getDouble(context, ARGS_NAME_CONFIG_ITEM);
        double value = DoubleArgumentType.getDouble(context, (String)ARGS_NAME_VALUE);
        if (value < item.Min) {
            value = item.Min;
        }
        if (value > item.Max) {
            value = item.Max;
        }
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.set(item, value).apply();
            ++num;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("parcool.command.message.success.set", new Object[]{num, item.getPath(), Double.toString(value)}), true);
        return 0;
    }

    private static int enableLimitation(CommandContext<CommandSource> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.func_197090_e(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSource)context.getSource()).func_197028_i());
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.enable().apply();
            ++num;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("parcool.command.message.success.enableLimitation", new Object[]{num}), true);
        return 0;
    }

    private static int disableLimitation(CommandContext<CommandSource> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.func_197090_e(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSource)context.getSource()).func_197028_i());
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.disable().apply();
            ++num;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("parcool.command.message.success.disableLimitation", new Object[]{num}), true);
        return 0;
    }

    private static int deleteLimitation(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Limitation.ID limitation = LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID);
        if (Limitation.delete(limitation)) {
            for (ServerPlayerEntity player : ((CommandSource)context.getSource()).func_197028_i().func_184103_al().func_181057_v()) {
                Limitations.update(player);
            }
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("parcool.command.message.success.deleteLimitation", new Object[]{limitation.toString()}), true);
        } else {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new StringTextComponent("Error:deleting folder failed"));
        }
        return 0;
    }

    private static int changeStaminaConsumption(CommandContext<CommandSource> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.func_197090_e(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSource)context.getSource()).func_197028_i());
        Class<? extends Action> action = ActionArgumentType.getAction(context, ARGS_NAME_ACTION);
        int newValue = IntegerArgumentType.getInteger(context, (String)ARGS_NAME_STAMINA_CONSUMPTION);
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.setLeastStaminaConsumption(action, newValue).apply();
            ++num;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("parcool.command.message.success.setStaminaConsumption", new Object[]{num, action.getSimpleName(), newValue}), true);
        return 0;
    }

    private static int changePossibilityOfAction(CommandContext<CommandSource> context, boolean hasID, boolean hasPlayer) throws CommandSyntaxException {
        List<Limitation> limitations = ControlLimitationCommand.getLimitationInstance(hasPlayer ? EntityArgument.func_197090_e(context, (String)ARGS_NAME_PLAYERS) : Collections.emptyList(), hasID ? LimitationIDArgumentType.getLimitationID(context, ARGS_NAME_LIMITATION_ID) : null, ((CommandSource)context.getSource()).func_197028_i());
        Class<? extends Action> action = ActionArgumentType.getAction(context, ARGS_NAME_ACTION);
        boolean newValue = BoolArgumentType.getBool(context, (String)ARGS_NAME_POSSIBILITY);
        int num = 0;
        for (Limitation limitation : limitations) {
            limitation.permit(action, newValue).apply();
            ++num;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("parcool.command.message.success.setPermissionOfAction", new Object[]{num, action.getSimpleName(), newValue}), true);
        return 0;
    }
}

