/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.utilities;

import com.alrex.parcool.common.action.impl.HangDown;
import com.alrex.parcool.utilities.VectorUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallHeight;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class WorldUtil {
    public static Vector3d getRunnableWall(LivingEntity entity, double range) {
        double width = entity.func_213311_cf() * 0.4f;
        double wallX = 0.0;
        double wallZ = 0.0;
        Vector3d pos = entity.func_213303_ch();
        AxisAlignedBB baseBox1 = new AxisAlignedBB(pos.func_82615_a() - width, pos.func_82617_b(), pos.func_82616_c() - width, pos.func_82615_a() + width, pos.func_82617_b() + (double)entity.func_213302_cg() / 1.63, pos.func_82616_c() + width);
        AxisAlignedBB baseBox2 = new AxisAlignedBB(pos.func_82615_a() - width, pos.func_82617_b() + (double)entity.func_213302_cg() / 1.63, pos.func_82616_c() - width, pos.func_82615_a() + width, pos.func_82617_b() + (double)entity.func_213302_cg(), pos.func_82616_c() + width);
        if (!entity.field_70170_p.func_226664_a_(baseBox1.func_72321_a(range, 0.0, 0.0)) && !entity.field_70170_p.func_226664_a_(baseBox2.func_72321_a(range, 0.0, 0.0))) {
            wallX += 1.0;
        }
        if (!entity.field_70170_p.func_226664_a_(baseBox1.func_72321_a(-range, 0.0, 0.0)) && !entity.field_70170_p.func_226664_a_(baseBox2.func_72321_a(-range, 0.0, 0.0))) {
            wallX -= 1.0;
        }
        if (!entity.field_70170_p.func_226664_a_(baseBox1.func_72321_a(0.0, 0.0, range)) && !entity.field_70170_p.func_226664_a_(baseBox2.func_72321_a(0.0, 0.0, range))) {
            wallZ += 1.0;
        }
        if (!entity.field_70170_p.func_226664_a_(baseBox1.func_72321_a(0.0, 0.0, -range)) && !entity.field_70170_p.func_226664_a_(baseBox1.func_72321_a(0.0, 0.0, -range))) {
            wallZ -= 1.0;
        }
        if (wallX == 0.0 && wallZ == 0.0) {
            return null;
        }
        return new Vector3d(wallX, 0.0, wallZ);
    }

    @Nullable
    public static Vector3d getWall(LivingEntity entity) {
        double range = entity.func_213311_cf() / 2.0f;
        double width = (double)entity.func_213311_cf() * 0.49;
        double wallX = 0.0;
        double wallZ = 0.0;
        Vector3d pos = entity.func_213303_ch();
        AxisAlignedBB baseBox = new AxisAlignedBB(pos.func_82615_a() - width, pos.func_82617_b(), pos.func_82616_c() - width, pos.func_82615_a() + width, pos.func_82617_b() + (double)entity.func_213302_cg(), pos.func_82616_c() + width);
        if (!entity.field_70170_p.func_226664_a_(baseBox.func_72321_a(range, 0.0, 0.0))) {
            wallX += 1.0;
        }
        if (!entity.field_70170_p.func_226664_a_(baseBox.func_72321_a(-range, 0.0, 0.0))) {
            wallX -= 1.0;
        }
        if (!entity.field_70170_p.func_226664_a_(baseBox.func_72321_a(0.0, 0.0, range))) {
            wallZ += 1.0;
        }
        if (!entity.field_70170_p.func_226664_a_(baseBox.func_72321_a(0.0, 0.0, -range))) {
            wallZ -= 1.0;
        }
        if (wallX == 0.0 && wallZ == 0.0) {
            return null;
        }
        return new Vector3d(wallX, 0.0, wallZ);
    }

    @Nullable
    public static Vector3d getVaultableStep(LivingEntity entity) {
        double d = (double)entity.func_213311_cf() * 0.5;
        World world = entity.field_70170_p;
        double distance = entity.func_213311_cf() / 2.0f;
        double baseLine = Math.min((double)entity.func_213302_cg() * 0.86, WorldUtil.getWallHeight(entity));
        double stepX = 0.0;
        double stepZ = 0.0;
        Vector3d pos = entity.func_213303_ch();
        AxisAlignedBB baseBoxBottom = new AxisAlignedBB(pos.func_82615_a() - d, pos.func_82617_b(), pos.func_82616_c() - d, pos.func_82615_a() + d, pos.func_82617_b() + baseLine, pos.func_82616_c() + d);
        AxisAlignedBB baseBoxTop = new AxisAlignedBB(pos.func_82615_a() - d, pos.func_82617_b() + baseLine, pos.func_82616_c() - d, pos.func_82615_a() + d, pos.func_82617_b() + baseLine + (double)entity.func_213302_cg(), pos.func_82616_c() + d);
        if (!world.func_226664_a_(baseBoxBottom.func_72321_a(distance, 0.0, 0.0)) && world.func_226664_a_(baseBoxTop.func_72321_a(distance + 1.8, 0.0, 0.0))) {
            stepX += 1.0;
        }
        if (!world.func_226664_a_(baseBoxBottom.func_72321_a(-distance, 0.0, 0.0)) && world.func_226664_a_(baseBoxTop.func_72321_a(-(distance + 1.8), 0.0, 0.0))) {
            stepX -= 1.0;
        }
        if (!world.func_226664_a_(baseBoxBottom.func_72321_a(0.0, 0.0, distance)) && world.func_226664_a_(baseBoxTop.func_72321_a(0.0, 0.0, distance + 1.8))) {
            stepZ += 1.0;
        }
        if (!world.func_226664_a_(baseBoxBottom.func_72321_a(0.0, 0.0, -distance)) && world.func_226664_a_(baseBoxTop.func_72321_a(0.0, 0.0, -(distance + 1.8)))) {
            stepZ -= 1.0;
        }
        if (stepX == 0.0 && stepZ == 0.0) {
            return null;
        }
        if (stepX == 0.0 || stepZ == 0.0) {
            Vector3d result = new Vector3d(stepX, 0.0, stepZ);
            BlockPos target = new BlockPos(entity.func_213303_ch().func_178787_e(result).func_72441_c(0.0, 0.5, 0.0));
            if (!world.func_195588_v(target)) {
                return null;
            }
            BlockState state = world.func_180495_p(target);
            if (state.func_177230_c() instanceof StairsBlock) {
                Half half = (Half)state.func_177229_b((Property)StairsBlock.field_176308_b);
                if (half != Half.BOTTOM) {
                    return result;
                }
                Direction direction = (Direction)state.func_177229_b((Property)StairsBlock.field_176309_a);
                if (stepZ > 0.0 && direction == Direction.SOUTH) {
                    return null;
                }
                if (stepZ < 0.0 && direction == Direction.NORTH) {
                    return null;
                }
                if (stepX > 0.0 && direction == Direction.EAST) {
                    return null;
                }
                if (stepX < 0.0 && direction == Direction.WEST) {
                    return null;
                }
            }
        }
        return new Vector3d(stepX, 0.0, stepZ);
    }

    public static double getWallHeight(LivingEntity entity, Vector3d direction, double maxHeight, double accuracy) {
        double d = (double)entity.func_213311_cf() * 0.49;
        direction = direction.func_72432_b();
        World world = entity.field_70170_p;
        Vector3d pos = entity.func_213303_ch();
        boolean canReturn = false;
        for (double height = 0.0; height < maxHeight; height += accuracy) {
            AxisAlignedBB box = new AxisAlignedBB(pos.func_82615_a() + d + (double)(direction.func_82615_a() > 0.0 ? 1 : 0), pos.func_82617_b() + height, pos.func_82616_c() + d + (double)(direction.func_82616_c() > 0.0 ? 1 : 0), pos.func_82615_a() - d + (double)(direction.func_82615_a() < 0.0 ? -1 : 0), pos.func_82617_b() + height + accuracy, pos.func_82616_c() - d + (double)(direction.func_82616_c() < 0.0 ? -1 : 0));
            if (!world.func_226664_a_(box)) {
                canReturn = true;
                continue;
            }
            if (!canReturn) continue;
            return height;
        }
        return maxHeight;
    }

    public static double getWallHeight(LivingEntity entity) {
        Vector3d wall = WorldUtil.getWall(entity);
        if (wall == null) {
            return 0.0;
        }
        World world = entity.field_70170_p;
        double accuracy = entity.func_213302_cg() / 18.0f;
        double d = (double)entity.func_213311_cf() * 0.5;
        int loopNum = (int)Math.round((double)entity.func_213302_cg() / accuracy);
        Vector3d pos = entity.func_213303_ch();
        boolean canReturn = false;
        for (int i = 0; i < loopNum; ++i) {
            AxisAlignedBB box = new AxisAlignedBB(pos.func_82615_a() + d + (double)(wall.func_82615_a() > 0.0 ? 1 : 0), pos.func_82617_b() + accuracy * (double)i, pos.func_82616_c() + d + (double)(wall.func_82616_c() > 0.0 ? 1 : 0), pos.func_82615_a() - d + (double)(wall.func_82615_a() < 0.0 ? -1 : 0), pos.func_82617_b() + accuracy * (double)(i + 1), pos.func_82616_c() - d + (double)(wall.func_82616_c() < 0.0 ? -1 : 0));
            if (!world.func_226664_a_(box)) {
                canReturn = true;
                continue;
            }
            if (!canReturn) continue;
            return accuracy * (double)i;
        }
        return entity.func_213302_cg();
    }

    @Nullable
    public static HangDown.BarAxis getHangableBars(LivingEntity entity) {
        double bbWidth = entity.func_213311_cf() / 4.0f;
        double bbHeight = 0.35;
        AxisAlignedBB bb = new AxisAlignedBB(entity.func_226277_ct_() - bbWidth, entity.func_226278_cu_() + (double)entity.func_213302_cg(), entity.func_226281_cx_() - bbWidth, entity.func_226277_ct_() + bbWidth, entity.func_226278_cu_() + (double)entity.func_213302_cg() + 0.35, entity.func_226281_cx_() + bbWidth);
        if (entity.field_70170_p.func_226664_a_(bb)) {
            return null;
        }
        BlockPos pos = new BlockPos(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_213302_cg() + 0.4, entity.func_226281_cx_());
        if (!entity.field_70170_p.func_195588_v(pos)) {
            return null;
        }
        BlockState state = entity.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        HangDown.BarAxis axis = null;
        if (block instanceof RotatedPillarBlock) {
            if (state.func_235785_r_((IBlockReader)entity.field_70170_p, pos)) {
                return null;
            }
            Direction.Axis pillarAxis = (Direction.Axis)state.func_177229_b((Property)RotatedPillarBlock.field_176298_M);
            switch (pillarAxis) {
                case X: {
                    axis = HangDown.BarAxis.X;
                    break;
                }
                case Z: {
                    axis = HangDown.BarAxis.Z;
                }
            }
        } else if (block instanceof DirectionalBlock) {
            if (state.func_235785_r_((IBlockReader)entity.field_70170_p, pos)) {
                return null;
            }
            Direction direction = (Direction)state.func_177229_b((Property)DirectionalBlock.field_176387_N);
            switch (direction) {
                case EAST: 
                case WEST: {
                    axis = HangDown.BarAxis.X;
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    axis = HangDown.BarAxis.Z;
                }
            }
        } else if (block instanceof FourWayBlock) {
            int zCount = 0;
            int xCount = 0;
            if (((Boolean)state.func_177229_b((Property)FourWayBlock.field_196409_a)).booleanValue()) {
                ++zCount;
            }
            if (((Boolean)state.func_177229_b((Property)FourWayBlock.field_196413_c)).booleanValue()) {
                ++zCount;
            }
            if (((Boolean)state.func_177229_b((Property)FourWayBlock.field_196411_b)).booleanValue()) {
                ++xCount;
            }
            if (((Boolean)state.func_177229_b((Property)FourWayBlock.field_196414_y)).booleanValue()) {
                ++xCount;
            }
            if (zCount > 0 && xCount == 0) {
                axis = HangDown.BarAxis.Z;
            }
            if (xCount > 0 && zCount == 0) {
                axis = HangDown.BarAxis.X;
            }
        } else if (block instanceof WallBlock) {
            int zCount = 0;
            int xCount = 0;
            if (state.func_177229_b((Property)WallBlock.field_235613_c_) != WallHeight.NONE) {
                ++zCount;
            }
            if (state.func_177229_b((Property)WallBlock.field_235614_d_) != WallHeight.NONE) {
                ++zCount;
            }
            if (state.func_177229_b((Property)WallBlock.field_235612_b_) != WallHeight.NONE) {
                ++xCount;
            }
            if (state.func_177229_b((Property)WallBlock.field_235615_e_) != WallHeight.NONE) {
                ++xCount;
            }
            if (zCount > 0 && xCount == 0) {
                axis = HangDown.BarAxis.Z;
            }
            if (xCount > 0 && zCount == 0) {
                axis = HangDown.BarAxis.X;
            }
        }
        return axis;
    }

    public static boolean existsSpaceBelow(LivingEntity entity) {
        World world = entity.field_70170_p;
        Vector3d center = entity.func_213303_ch();
        if (!world.func_195588_v(new BlockPos(center))) {
            return false;
        }
        double height = (double)entity.func_213302_cg() * 1.5;
        double width = entity.func_213311_cf() * 2.0f;
        AxisAlignedBB boundingBox = new AxisAlignedBB(center.func_82615_a() - width, center.func_82617_b() - 9.0, center.func_82616_c() - width, center.func_82615_a() + width, center.func_82617_b() + height, center.func_82616_c() + width);
        return world.func_226664_a_(boundingBox);
    }

    public static boolean existsDivableSpace(LivingEntity entity) {
        int i;
        World world = entity.field_70170_p;
        double width = (double)entity.func_213311_cf() * 1.5;
        double height = (double)entity.func_213302_cg() * 1.5;
        double wideWidth = entity.func_213311_cf() * 2.0f;
        Vector3d center = entity.func_213303_ch();
        if (!world.func_195588_v(new BlockPos(center))) {
            return false;
        }
        Vector3d diveDirection = VectorUtil.fromYawDegree(entity.func_70079_am());
        for (int i2 = 0; i2 < 4; ++i2) {
            Vector3d centerPoint = center.func_178787_e(diveDirection.func_186678_a(width * (double)i2));
            AxisAlignedBB box = new AxisAlignedBB(centerPoint.func_82615_a() - width, centerPoint.func_82617_b() + 0.05, centerPoint.func_82616_c() - width, centerPoint.func_82615_a() + width, centerPoint.func_82617_b() + height, centerPoint.func_82616_c() + width);
            if (world.func_226664_a_(box)) continue;
            return false;
        }
        AxisAlignedBB verticalWideBox = new AxisAlignedBB((center = center.func_178787_e(diveDirection.func_186678_a(4.0))).func_82615_a() - wideWidth, center.func_82617_b() - 9.0, center.func_82616_c() - wideWidth, center.func_82615_a() + wideWidth, center.func_82617_b() + height, center.func_82616_c() + wideWidth);
        if (world.func_226664_a_(verticalWideBox)) {
            return true;
        }
        BlockPos centerBlockPos = new BlockPos(center.func_72441_c(0.0, -0.5, 0.0));
        if (!world.func_195588_v(centerBlockPos)) {
            return false;
        }
        verticalWideBox = new AxisAlignedBB(center.func_82615_a() - wideWidth, center.func_82617_b() - 2.9, center.func_82616_c() - wideWidth, center.func_82615_a() + wideWidth, center.func_82617_b() + height, center.func_82616_c() + wideWidth);
        int waterLevel = -1;
        for (i = 0; i < 6; ++i) {
            Block block = world.func_180495_p(centerBlockPos.func_177979_c(i)).func_177230_c();
            if (block == Blocks.field_150350_a) continue;
            if (block == Blocks.field_150355_j) {
                waterLevel = i;
                break;
            }
            return false;
        }
        if (waterLevel == -1) {
            return false;
        }
        boolean filledWithWater = true;
        while (i < waterLevel + 3) {
            BlockState state = world.func_180495_p(centerBlockPos.func_177979_c(i));
            if (state.func_177230_c() != Blocks.field_150355_j) {
                filledWithWater = false;
                break;
            }
            ++i;
        }
        return filledWithWater && world.func_226664_a_(verticalWideBox);
    }

    @Nullable
    public static Vector3d getGrabbableWall(LivingEntity entity) {
        double d = (double)entity.func_213311_cf() * 0.5;
        World world = entity.field_70170_p;
        double distance = entity.func_213311_cf() / 2.0f;
        double baseLine1 = entity.func_70047_e() + (entity.func_213302_cg() - entity.func_70047_e()) / 2.0f;
        double baseLine2 = entity.func_213302_cg() + (entity.func_213302_cg() - entity.func_70047_e()) / 2.0f;
        Vector3d wall1 = WorldUtil.getGrabbableWall(entity, distance, baseLine1);
        if (wall1 != null) {
            return wall1;
        }
        return WorldUtil.getGrabbableWall(entity, distance, baseLine2);
    }

    private static Vector3d getGrabbableWall(LivingEntity entity, double distance, double baseLine) {
        float slipperiness;
        double d = (double)entity.func_213311_cf() * 0.49;
        World world = entity.field_70170_p;
        Vector3d pos = entity.func_213303_ch();
        AxisAlignedBB baseBoxSide = new AxisAlignedBB(pos.func_82615_a() - d, pos.func_82617_b() + baseLine - (double)(entity.func_213302_cg() / 6.0f), pos.func_82616_c() - d, pos.func_82615_a() + d, pos.func_82617_b() + baseLine, pos.func_82616_c() + d);
        AxisAlignedBB baseBoxTop = new AxisAlignedBB(pos.func_82615_a() - d, pos.func_82617_b() + baseLine, pos.func_82616_c() - d, pos.func_82615_a() + d, pos.func_82617_b() + (double)entity.func_213302_cg(), pos.func_82616_c() + d);
        int xDirection = 0;
        int zDirection = 0;
        if (!world.func_226664_a_(baseBoxSide.func_72321_a(distance, 0.0, 0.0)) && world.func_226664_a_(baseBoxTop.func_72321_a(distance, 0.0, 0.0))) {
            ++xDirection;
        }
        if (!world.func_226664_a_(baseBoxSide.func_72321_a(-distance, 0.0, 0.0)) && world.func_226664_a_(baseBoxTop.func_72321_a(-distance, 0.0, 0.0))) {
            --xDirection;
        }
        if (!world.func_226664_a_(baseBoxSide.func_72321_a(0.0, 0.0, distance)) && world.func_226664_a_(baseBoxTop.func_72321_a(0.0, 0.0, distance))) {
            ++zDirection;
        }
        if (!world.func_226664_a_(baseBoxSide.func_72321_a(0.0, 0.0, -distance)) && world.func_226664_a_(baseBoxTop.func_72321_a(0.0, 0.0, -distance))) {
            --zDirection;
        }
        if (xDirection == 0 && zDirection == 0) {
            return null;
        }
        if (xDirection != 0 && zDirection != 0) {
            BlockPos blockPos1 = new BlockPos(entity.func_226277_ct_() + (double)xDirection, entity.func_174813_aQ().field_72338_b + baseLine - 0.3, entity.func_226281_cx_());
            BlockPos blockPos2 = new BlockPos(entity.func_226277_ct_(), entity.func_174813_aQ().field_72338_b + baseLine - 0.3, entity.func_226281_cx_() + (double)zDirection);
            if (!entity.field_70170_p.func_195588_v(blockPos1)) {
                return null;
            }
            if (!entity.field_70170_p.func_195588_v(blockPos2)) {
                return null;
            }
            slipperiness = Math.min(entity.field_70170_p.func_180495_p(blockPos1).getSlipperiness((IWorldReader)entity.field_70170_p, blockPos1, (Entity)entity), entity.field_70170_p.func_180495_p(blockPos2).getSlipperiness((IWorldReader)entity.field_70170_p, blockPos2, (Entity)entity));
        } else {
            BlockPos blockPos = new BlockPos(entity.func_226277_ct_() + (double)xDirection, entity.func_174813_aQ().field_72338_b + baseLine - 0.3, entity.func_226281_cx_() + (double)zDirection);
            if (!entity.field_70170_p.func_195588_v(blockPos)) {
                return null;
            }
            slipperiness = entity.field_70170_p.func_180495_p(blockPos).getSlipperiness((IWorldReader)entity.field_70170_p, blockPos, (Entity)entity);
        }
        return (double)slipperiness <= 0.9 ? new Vector3d((double)xDirection, 0.0, (double)zDirection) : null;
    }
}

