/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation;

import com.alrex.parcool.utilities.VectorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class PlayerModelRotator {
    private final PoseStack stack;
    private final Player player;
    private final float partial;
    private boolean basedCenter = false;
    private boolean legGrounding = false;
    private float angleFront = 0.0f;

    public float getPartialTick() {
        return this.partial;
    }

    public PlayerModelRotator(PoseStack stack, Player player, float partial) {
        this.stack = stack;
        this.player = player;
        this.partial = partial;
    }

    public PlayerModelRotator start() {
        return this;
    }

    public PlayerModelRotator startBasedCenter() {
        this.basedCenter = true;
        this.stack.m_85837_(0.0, (double)(this.player.m_20206_() / 2.0f), 0.0);
        return this;
    }

    public PlayerModelRotator rotateFrontward(float angleDegree) {
        Vec3 lookVec = VectorUtil.fromYawDegree(this.player.f_20883_).m_82524_(1.5707964f);
        Vector3f vec = new Vector3f((float)lookVec.m_7096_(), 0.0f, (float)lookVec.m_7094_());
        this.angleFront += angleDegree;
        this.stack.m_85845_(vec.m_122240_(angleDegree));
        return this;
    }

    public PlayerModelRotator rotateRightward(float angleDegree) {
        Vec3 lookVec = VectorUtil.fromYawDegree(this.player.f_20883_);
        Vector3f vec = new Vector3f((float)lookVec.m_7096_(), 0.0f, (float)lookVec.m_7094_());
        this.stack.m_85845_(vec.m_122240_(angleDegree));
        return this;
    }

    public void end() {
        if (this.basedCenter) {
            this.stack.m_85837_(0.0, (double)(-this.player.m_20206_() / 2.0f), 0.0);
        }
    }

    public void endEnabledLegGrounding() {
        if (this.basedCenter) {
            this.stack.m_85837_(0.0, (double)(-this.player.m_20206_() / 2.0f), 0.0);
        }
    }
}

