/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.action.impl.Dodge;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.MathUtil;
import net.minecraft.world.entity.player.Player;

public class DodgeAnimator
extends Animator {
    private boolean notInitialized = true;
    private boolean frontLeg = false;

    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return !parkourability.getDodge().isDodging();
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        float phase = ((float)this.getTick() + transformer.getPartialTick()) / 6.0f;
        if (phase > 1.0f) {
            return;
        }
        float factor = this.factorFunc(phase);
        float revision = -MathUtil.lerp(0.0f, 30.0f, factor);
        switch (parkourability.getDodge().getDodgeDirection()) {
            case Front: {
                transformer.rotateAdditionallyHeadPitch(revision);
                if (this.notInitialized) {
                    this.frontLeg = player.m_21187_().nextBoolean();
                    this.notInitialized = false;
                }
                if (this.frontLeg) {
                    transformer.rotateRightLeg((float)Math.toRadians(-MathUtil.lerp(10.0f, 35.0f, factor) + revision), 0.0f, 0.0f).rotateLeftLeg((float)Math.toRadians(MathUtil.lerp(30.0f, 60.0f, factor) + revision), 0.0f, 0.0f).end();
                    break;
                }
                transformer.rotateRightLeg((float)Math.toRadians(MathUtil.lerp(30.0f, 60.0f, factor) + revision), 0.0f, 0.0f).rotateLeftLeg((float)Math.toRadians(-MathUtil.lerp(10.0f, 35.0f, factor) + revision), 0.0f, 0.0f).end();
                break;
            }
            case Right: {
                transformer.rotateAdditionallyHeadPitch(revision).rotateRightLeg((float)Math.toRadians(-MathUtil.lerp(10.0f, 35.0f, factor) + revision), 0.0f, 0.0f).rotateLeftLeg((float)Math.toRadians(MathUtil.lerp(30.0f, 60.0f, factor) + revision), 0.0f, 0.0f).end();
                break;
            }
            case Left: {
                transformer.rotateAdditionallyHeadPitch(revision).rotateRightLeg((float)Math.toRadians(MathUtil.lerp(30.0f, 60.0f, factor) + revision), 0.0f, 0.0f).rotateLeftLeg((float)Math.toRadians(-MathUtil.lerp(10.0f, 35.0f, factor) + revision), 0.0f, 0.0f).end();
                break;
            }
            case Back: {
                transformer.rotateAdditionallyHeadPitch(-revision);
                if (this.notInitialized) {
                    this.frontLeg = player.m_21187_().nextBoolean();
                    this.notInitialized = false;
                }
                if (this.frontLeg) {
                    transformer.rotateRightLeg((float)Math.toRadians(MathUtil.lerp(10.0f, 45.0f, factor)), 0.0f, 0.0f).rotateLeftLeg((float)Math.toRadians(-MathUtil.lerp(10.0f, 35.0f, factor)), 0.0f, 0.0f).end();
                    break;
                }
                transformer.rotateRightLeg((float)Math.toRadians(-MathUtil.lerp(10.0f, 35.0f, factor)), 0.0f, 0.0f).rotateLeftLeg((float)Math.toRadians(MathUtil.lerp(10.0f, 45.0f, factor)), 0.0f, 0.0f).end();
            }
        }
    }

    @Override
    public void rotate(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        float phase = ((float)this.getTick() + rotator.getPartialTick()) / 6.0f;
        if (phase > 1.0f) {
            return;
        }
        float factor = this.factorFunc(phase);
        rotator.startBasedCenter().rotateFrontward((float)(parkourability.getDodge().getDodgeDirection() == Dodge.DodgeDirection.Back ? -1 : 1) * MathUtil.lerp(0.0f, 30.0f, factor)).end();
    }

    private float factorFunc(float phase) {
        if ((double)phase < 0.8) {
            return 1.0f - 5.0f * (phase - 0.45f) * (phase - 0.45f);
        }
        return (phase - 1.0f) * (phase - 1.0f) * 9.3f;
    }
}

