/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.EasingFunctions;
import net.minecraft.world.entity.player.Player;

public class FastRunningAnimator
extends Animator {
    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return !parkourability.getFastRun().isRunning();
    }

    private float bodyAngleFactor(float phase) {
        return EasingFunctions.SinInOutBySquare(phase);
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        float phase = ((float)parkourability.getFastRun().getRunningTick() + transformer.getPartialTick()) / 10.0f;
        if (phase > 1.0f) {
            phase = 1.0f;
        }
        float bodyAngleFactor = this.bodyAngleFactor(phase);
        transformer.addRotateRightArm(0.0f, 0.0f, (float)Math.toRadians(bodyAngleFactor * 10.0f)).addRotateLeftArm(0.0f, 0.0f, (float)Math.toRadians(bodyAngleFactor * -10.0f)).rotateAdditionallyHeadPitch(bodyAngleFactor * -20.0f).makeArmsNatural().end();
    }

    @Override
    public void rotate(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        float phase = ((float)parkourability.getFastRun().getRunningTick() + rotator.getPartialTick()) / 10.0f;
        if (phase > 1.0f) {
            phase = 1.0f;
        }
        float bodyAngle = this.bodyAngleFactor(phase) * 20.0f;
        rotator.startBasedCenter().rotateFrontward(bodyAngle).end();
    }
}

