/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;

public class RollAnimator
extends Animator {
    private final float cameraPitch;

    public RollAnimator() {
        this.cameraPitch = 20.0f;
    }

    public static float calculateMovementFactor(float progress) {
        return -MathUtil.squaring(progress - 1.0f) + 1.0f;
    }

    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return !parkourability.getRoll().isRolling();
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        Roll roll = parkourability.getRoll();
        float phase = ((float)roll.getRollingTick() + transformer.getPartialTick()) / (float)roll.getRollMaxTick();
        float factor = 1.0f - 4.0f * (0.5f - phase) * (0.5f - phase);
        transformer.addRotateLeftLeg((float)Math.toRadians(-70.0f * factor), 0.0f, 0.0f).addRotateRightLeg((float)Math.toRadians(-70.0f * factor), 0.0f, 0.0f).addRotateRightArm((float)Math.toRadians(-80.0f * factor), 0.0f, 0.0f).addRotateLeftArm((float)Math.toRadians(-80.0f * factor), 0.0f, 0.0f).end();
    }

    @Override
    public void rotate(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        Roll roll = parkourability.getRoll();
        float phase = ((float)roll.getRollingTick() + rotator.getPartialTick()) / (float)roll.getRollMaxTick();
        float factor = RollAnimator.calculateMovementFactor(phase);
        rotator.startBasedCenter().rotateFrontward(MathUtil.lerp(0.0f, 360.0f, factor)).end();
    }

    @Override
    public void onRender(TickEvent.RenderTickEvent event, Player clientPlayer, Parkourability parkourability) {
        Roll roll = parkourability.getRoll();
        if (roll.isRolling() && clientPlayer.m_7578_() && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && !((Boolean)ParCoolConfig.CONFIG_CLIENT.disableCameraRolling.get()).booleanValue()) {
            float factor = RollAnimator.calculateMovementFactor(((float)roll.getRollingTick() + event.renderTickTime) / (float)roll.getRollMaxTick());
            clientPlayer.m_146926_(((double)factor > 0.5 ? factor - 1.0f : factor) * 360.0f + this.cameraPitch);
        }
    }
}

