/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.EasingFunctions;
import net.minecraft.world.entity.player.Player;

public class TapAnimator
extends Animator {
    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return !parkourability.getTap().isTapping();
    }

    public float angleFactor(float phase) {
        if ((double)phase < 0.3) {
            return 1.0f - 11.0f * (phase - 0.3f) * (phase - 0.3f);
        }
        if ((double)phase < 0.7) {
            return 1.0f;
        }
        return 1.0f - EasingFunctions.SinInOutBySquare((phase - 0.7f) * 3.3f);
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        float phase = ((float)this.getTick() + transformer.getPartialTick()) / (float)parkourability.getTap().getMaxTappingTick();
        float factor = this.angleFactor(phase);
        float angle = 80.0f * factor;
        transformer.rotateLeftLeg((float)Math.toRadians(-angle), 0.0f, 0.0f).rotateRightLeg((float)Math.toRadians(-angle), 0.0f, 0.0f).rotateRightArm((float)Math.toRadians(-angle), 0.0f, (float)Math.toRadians(factor * 20.0f)).rotateLeftArm((float)Math.toRadians(-angle), 0.0f, (float)Math.toRadians(-factor * 20.0f)).makeArmsNatural().end();
    }

    @Override
    public void rotate(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        float phase = ((float)this.getTick() + rotator.getPartialTick()) / (float)parkourability.getTap().getMaxTappingTick();
        float angle = 80.0f * this.angleFactor(phase);
        rotator.startBasedCenter().rotateFrontward(angle).endEnabledLegGrounding();
    }
}

