/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.gui;

import com.alrex.parcool.client.gui.guidebook.Book;
import com.alrex.parcool.client.gui.guidebook.BookDecoder;
import com.alrex.parcool.client.gui.widget.ListView;
import com.alrex.parcool.utilities.ColorUtil;
import com.alrex.parcool.utilities.FontUtil;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParCoolGuideScreen
extends Screen {
    public static final ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("parcool:textures/gui/book_background.png");
    private static final int PAGE_HOME = -1;
    private int cachedPageNumber = 0;
    private List<FormattedText> cachedPage = null;
    private int currentPage = -1;
    private int scrollValue = 0;
    private final Book book = BookDecoder.getInstance().getBook();
    private final List<String> menuList = this.book.getPages().stream().map(Book.Page::getTitle).collect(Collectors.toList());
    private final int width = 300;
    private int height = 225;
    private final int menuOffsetX = 20;
    private final int menuOffsetY = 30;
    private int bookOffsetX = 0;
    private int bookOffsetY = 0;
    private final ListView menu = new ListView(this.menuList);

    protected ParCoolGuideScreen(Component titleIn) {
        super(titleIn);
    }

    public ParCoolGuideScreen() {
        super((Component)new TextComponent("ParCool"));
    }

    public void m_7856_() {
        this.menu.setListener(this::changePage);
        super.m_7856_();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float n) {
        this.m_7333_(stack);
        Minecraft mc = this.getMinecraft();
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND_LOCATION);
        this.m_96558_(stack, ColorUtil.getColorCodeFromARGB(119, 102, 102, 204));
        Window window = mc.m_91268_();
        this.bookOffsetX = (window.m_85445_() - 300) / 2;
        this.bookOffsetY = (window.m_85446_() - this.height) / 2;
        GuiComponent.m_93160_((PoseStack)stack, (int)this.bookOffsetX, (int)this.bookOffsetY, (int)300, (int)this.height, (float)0.0f, (float)0.0f, (int)256, (int)194, (int)256, (int)256);
        this.renderContent(stack, this.bookOffsetX, this.bookOffsetY, 150, this.height, mouseX, mouseY, n);
        this.renderMenu(stack, this.bookOffsetX + 150, this.bookOffsetY, 150, this.height, mouseX, mouseY, n);
    }

    public void m_96558_(PoseStack p_238651_1_, int p_238651_2_) {
        super.m_96558_(p_238651_1_, p_238651_2_);
    }

    public boolean m_6050_(double x, double y, double value) {
        super.m_6050_(x, y, value);
        this.scroll((int)(-value));
        return true;
    }

    public boolean m_7933_(int type, int p_231046_2_, int p_231046_3_) {
        if (super.m_7933_(type, p_231046_2_, p_231046_3_)) {
            return true;
        }
        switch (type) {
            case 265: {
                this.scroll(-1);
                return true;
            }
            case 264: {
                this.scroll(1);
                return true;
            }
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int type) {
        this.menu.onClick(type, mouseX, mouseY);
        return false;
    }

    private void renderContent(PoseStack stack, int left, int top, int width, int height, int mouseX, int mouseY, float n) {
        if (this.currentPage == -1) {
            this.renderHome(stack, left, top, width, height, mouseX, mouseY, n);
        } else {
            this.renderContentText(stack, left, top, width, height, mouseX, mouseY, n);
        }
    }

    private void scroll(int value) {
        if (this.cachedPage == null) {
            return;
        }
        this.scrollValue += value;
        if (this.scrollValue < 0) {
            this.scrollValue = 0;
        }
        if (this.cachedPage.size() < this.scrollValue) {
            this.scrollValue = this.cachedPage.size();
        }
    }

    private void renderHome(PoseStack stack, int left, int top, int width, int height, int mouseX, int mouseY, float n) {
        Minecraft mc = this.getMinecraft();
        Font fontRenderer = this.f_96547_;
        int offsetY = 20;
        int center = left + width / 2;
        String textTitle = "ParCool!";
        String textSubtitle = "Guide Book";
        GuiComponent.m_93160_((PoseStack)stack, (int)(left + width / 4), (int)(top + 20 + 50), (int)(width / 2), (int)(width / 2), (float)0.0f, (float)207.0f, (int)52, (int)49, (int)256, (int)256);
        FontUtil.drawCenteredText(stack, textTitle, center, top + 20 + 10, ColorUtil.getColorCodeFromARGB(255, 85, 85, 255));
        Objects.requireNonNull(fontRenderer);
        FontUtil.drawCenteredText(stack, textSubtitle, center, top + 20 + 15 + 9, ColorUtil.getColorCodeFromARGB(255, 68, 68, 187));
    }

    private void renderContentText(PoseStack stack, int left, int top, int width, int height, int mouseX, int mouseY, float n) {
        Minecraft mc = this.getMinecraft();
        Font fontRenderer = this.f_96547_;
        int offsetY = 15;
        int offsetX = 14;
        Objects.requireNonNull(fontRenderer);
        int lineHeight = 9 + 1;
        Objects.requireNonNull(fontRenderer);
        int titleHeight = 9 + 10;
        int contentHeight = height - 28 - titleHeight;
        int contentLine = contentHeight / lineHeight;
        if (this.currentPage < 0 || this.book.getPages().size() <= this.currentPage) {
            return;
        }
        Book.Page page = this.book.getPages().get(this.currentPage);
        if (this.cachedPageNumber != this.currentPage || this.cachedPage == null) {
            ArrayList<FormattedText> wrappedLines = new ArrayList<FormattedText>();
            page.getContent().forEach(text -> {
                if (text.isEmpty()) {
                    wrappedLines.add(FormattedText.f_130760_);
                } else {
                    wrappedLines.addAll(fontRenderer.m_92865_().m_92432_(text, (int)((double)width - 22.400000000000002), Style.f_131099_));
                }
            });
            this.cachedPage = wrappedLines;
            this.cachedPageNumber = this.currentPage;
        }
        FontUtil.drawCenteredText(stack, page.getTitle(), left + width / 2, top + 15 + titleHeight / 2, ColorUtil.getColorCodeFromARGB(255, 0, 0, 0));
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i + this.scrollValue < Math.min(contentLine + this.scrollValue, this.cachedPage.size())) {
            builder.append(this.cachedPage.get(i + this.scrollValue).getString()).append('\n');
            ++i;
        }
        fontRenderer.m_92857_((FormattedText)new TextComponent(builder.toString()), left + 14, top + 15 + titleHeight, width - 14, ColorUtil.getColorCodeFromARGB(0, 0, 0, 0));
    }

    private void renderMenu(PoseStack stack, int left, int top, int width, int height, int mouseX, int mouseY, float n) {
        Font fontRenderer = this.f_96547_;
        int offsetY = 20;
        FontUtil.drawCenteredText(stack, "Index", left + width / 2, top + offsetY, ColorUtil.getColorCodeFromARGB(255, 102, 102, 255));
        this.menu.setX(left + 20);
        this.menu.setY(top + 30);
        this.menu.setWidth(width - 40);
        this.menu.setHeight(height - 60);
        this.menu.render(stack, fontRenderer, mouseX, mouseY, n);
    }

    private void changePage(int i) {
        if (i != -1 && (i < 0 || this.book.getPages().size() <= i)) {
            return;
        }
        this.scrollValue = 0;
        this.currentPage = i;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.m_5496_(SoundEvents.f_11713_, 1.0f, 1.0f);
        }
    }
}

