/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.gui.widget;

import com.alrex.parcool.client.gui.widget.Widget;
import com.alrex.parcool.utilities.WidgetUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.util.Tuple;

public class WidgetListView<T extends AbstractWidget>
extends Widget {
    List<T> items;
    private int scrollValue = 0;
    private final int itemHeight;

    public WidgetListView(int x, int y, int width, int height, List<T> items, int itemHeight) {
        super(x, y, width, height);
        this.items = items;
        this.itemHeight = itemHeight;
    }

    @Override
    public void render(PoseStack stack, Font fontRenderer, int mouseX, int mouseY, float partial) {
        int renderingY = 0;
        for (int i = this.scrollValue; i < this.items.size(); ++i) {
            AbstractWidget item = (AbstractWidget)this.items.get(i);
            WidgetUtil.setX(item, this.x);
            WidgetUtil.setY(item, this.y + renderingY);
            WidgetUtil.setWidth(item, this.width);
            WidgetUtil.setHeight(item, this.itemHeight);
            if (renderingY + item.m_93694_() > this.height) break;
            item.m_6305_(stack, mouseX, mouseY, partial);
            renderingY += item.m_93694_();
        }
    }

    public void scroll(int value) {
        this.scrollValue += value;
        int max = this.items.size() - this.height / this.itemHeight;
        if (this.scrollValue > max) {
            this.scrollValue = max;
        }
        if (this.scrollValue < 0) {
            this.scrollValue = 0;
        }
    }

    @Nullable
    public Tuple<Integer, T> clicked(double mouse_X, double mouse_Y, int type) {
        if (mouse_X < (double)this.x || (double)(this.x + this.width) < mouse_X) {
            return null;
        }
        if (mouse_Y < (double)this.y || (double)(this.y + this.height) < mouse_Y) {
            return null;
        }
        int index = this.scrollValue + (int)Math.floor((mouse_Y - (double)this.y) / (double)this.itemHeight);
        if (index < this.items.size()) {
            return new Tuple((Object)index, (Object)((AbstractWidget)this.items.get(index)));
        }
        return null;
    }
}

