/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.hud.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.hud.AbstractHUD;
import com.alrex.parcool.client.hud.Position;
import com.alrex.parcool.client.hud.impl.StaminaHUD;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.ForgeIngameGui;

public class LightStaminaHUD
extends AbstractHUD {
    private int oldValue = 0;
    private long lastChangedTick = 0L;

    public LightStaminaHUD(Position pos) {
        super(pos);
    }

    @Override
    public void render(ForgeIngameGui gui, PoseStack mStack, float partialTicks, int width, int height) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || player.m_19941_((Tag)FluidTags.f_13131_)) {
            return;
        }
        if (player.m_7500_()) {
            return;
        }
        Stamina stamina = Stamina.get((Player)player);
        Parkourability parkourability = Parkourability.get((Player)player);
        if (stamina == null || parkourability == null) {
            return;
        }
        if (((Boolean)ParCoolConfig.CONFIG_CLIENT.infiniteStamina.get()).booleanValue() && parkourability.getActionInfo().isStaminaInfinite()) {
            return;
        }
        if (stamina.getStamina() == 0) {
            return;
        }
        long gameTime = player.f_19853_.m_46467_();
        if (stamina.getStamina() != this.oldValue) {
            this.lastChangedTick = gameTime;
        } else if (gameTime - this.lastChangedTick > 40L) {
            return;
        }
        this.oldValue = stamina.getStamina();
        float staminaScale = (float)stamina.getStamina() / (float)stamina.getMaxStamina();
        if (staminaScale < 0.0f) {
            staminaScale = 0.0f;
        }
        if (staminaScale > 1.0f) {
            staminaScale = 1.0f;
        }
        Minecraft mc = Minecraft.m_91087_();
        int scaledWidth = mc.m_91268_().m_85445_();
        int scaledHeight = mc.m_91268_().m_85446_();
        int iconNumber = (int)Math.floor(staminaScale * 10.0f);
        float iconPartial = staminaScale * 10.0f - (float)iconNumber;
        RenderSystem.m_157456_((int)0, (ResourceLocation)StaminaHUD.STAMINA);
        int baseX = scaledWidth / 2 + 92;
        int y = scaledHeight - 49 + (Integer)ParCoolConfig.CONFIG_CLIENT.offsetVerticalLightStaminaHUD.get();
        for (int i = 1; i <= 10; ++i) {
            int textureX;
            int x = baseX - i * 8 - 1;
            if (iconNumber >= i || iconNumber + 1 == i && (double)iconPartial > 0.3) {
                textureX = 0;
            } else {
                if (iconNumber + 1 != i) break;
                textureX = 8;
            }
            if (stamina.isExhausted()) {
                textureX += 16;
            }
            AbstractHUD.m_93133_((PoseStack)mStack, (int)x, (int)y, (float)textureX, (float)119.0f, (int)8, (int)9, (int)128, (int)128);
        }
    }
}

