/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.WallSlideAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class WallSlide
extends Action {
    private boolean sliding = false;
    private int slidingTick = 0;
    private Vec3 leanedWallDirection = null;

    public boolean isSliding() {
        return this.sliding;
    }

    @Nullable
    public Vec3 getLeanedWallDirection() {
        return this.leanedWallDirection;
    }

    @Override
    public void onTick(Player player, Parkourability parkourability, Stamina stamina) {
        if (this.sliding) {
            ++this.slidingTick;
            this.leanedWallDirection = WorldUtil.getWall((LivingEntity)player);
            if (this.leanedWallDirection != null) {
                BlockPos leanedBlock = new BlockPos(player.m_20185_() + this.leanedWallDirection.m_7096_(), player.m_142469_().f_82289_ + (double)player.m_20206_() * 0.75, player.m_20189_() + this.leanedWallDirection.m_7094_());
                float slipperiness = player.f_19853_.m_8055_(leanedBlock).getFriction((LevelReader)player.f_19853_, leanedBlock, (Entity)player);
                slipperiness = (float)Math.sqrt(slipperiness);
                player.f_19789_ *= slipperiness;
                player.m_20256_(player.m_20184_().m_82542_(0.8, (double)slipperiness, 0.8));
            }
        } else {
            this.slidingTick = 0;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, Stamina stamina) {
        Animation animation;
        if (player.m_7578_()) {
            Vec3 wall = WorldUtil.getWall((LivingEntity)player);
            boolean bl = this.sliding = !player.m_20096_() && parkourability.getPermission().canWallSlide() && !parkourability.getFastRun().isRunning() && !parkourability.getDodge().isDodging() && !player.m_150110_().f_35935_ && player.m_20184_().m_7098_() <= 0.0 && wall != null && KeyBindings.getKeyWallSlide().m_90857_() && !stamina.isExhausted() && !parkourability.getClingToCliff().isCling() && parkourability.getClingToCliff().getNotClingTick() > 12;
        }
        if (this.sliding && (animation = Animation.get(player)) != null && !animation.hasAnimator()) {
            animation.setAnimator(new WallSlideAnimator());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
    }

    @Override
    public void restoreState(ByteBuffer buffer) {
        this.sliding = BufferUtil.getBoolean(buffer);
    }

    @Override
    public void saveState(ByteBuffer buffer) {
        BufferUtil.wrap(buffer).putBoolean(this.sliding);
    }
}

