/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.info.ActionInfo;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class ActionPermissionsMessage {
    private boolean allowedCatLeap;
    private boolean allowedCrawl;
    private boolean allowedDodge;
    private boolean allowedFastRunning;
    private boolean allowedClingToCliff;
    private boolean allowedRoll;
    private boolean allowedVault;
    private boolean allowedWallJump;
    private boolean allowedFlipping;
    private boolean allowedBreakfall;
    private boolean allowedWallSlide;
    private boolean allowedHorizontalWallRun;
    private boolean allowedInfiniteStamina;
    private byte[] infoData = null;

    public boolean isAllowedCatLeap() {
        return this.allowedCatLeap;
    }

    public boolean isAllowedClingToCliff() {
        return this.allowedClingToCliff;
    }

    public boolean isAllowedCrawl() {
        return this.allowedCrawl;
    }

    public boolean isAllowedDodge() {
        return this.allowedDodge;
    }

    public boolean isAllowedFastRunning() {
        return this.allowedFastRunning;
    }

    public boolean isAllowedRoll() {
        return this.allowedRoll;
    }

    public boolean isAllowedVault() {
        return this.allowedVault;
    }

    public boolean isAllowedWallJump() {
        return this.allowedWallJump;
    }

    public boolean isAllowedFlipping() {
        return this.allowedFlipping;
    }

    public boolean isAllowedBreakfall() {
        return this.allowedBreakfall;
    }

    public boolean isAllowedWallSlide() {
        return this.allowedWallSlide;
    }

    public boolean isAllowedHorizontalWallRun() {
        return this.allowedHorizontalWallRun;
    }

    public void encode(FriendlyByteBuf packet) {
        packet.writeBoolean(this.allowedCatLeap);
        packet.writeBoolean(this.allowedCrawl);
        packet.writeBoolean(this.allowedDodge);
        packet.writeBoolean(this.allowedFastRunning);
        packet.writeBoolean(this.allowedClingToCliff);
        packet.writeBoolean(this.allowedRoll);
        packet.writeBoolean(this.allowedVault);
        packet.writeBoolean(this.allowedWallJump);
        packet.writeBoolean(this.allowedInfiniteStamina);
        packet.writeBoolean(this.allowedBreakfall);
        packet.writeBoolean(this.allowedFlipping);
        packet.writeBoolean(this.allowedWallSlide);
        packet.writeBoolean(this.allowedHorizontalWallRun);
        packet.m_130087_(this.infoData);
    }

    public static ActionPermissionsMessage decode(FriendlyByteBuf packet) {
        ActionPermissionsMessage message = new ActionPermissionsMessage();
        message.allowedCatLeap = packet.readBoolean();
        message.allowedCrawl = packet.readBoolean();
        message.allowedDodge = packet.readBoolean();
        message.allowedFastRunning = packet.readBoolean();
        message.allowedClingToCliff = packet.readBoolean();
        message.allowedRoll = packet.readBoolean();
        message.allowedVault = packet.readBoolean();
        message.allowedWallJump = packet.readBoolean();
        message.allowedInfiniteStamina = packet.readBoolean();
        message.allowedBreakfall = packet.readBoolean();
        message.allowedFlipping = packet.readBoolean();
        message.allowedWallSlide = packet.readBoolean();
        message.allowedHorizontalWallRun = packet.readBoolean();
        message.infoData = packet.m_130052_();
        return message;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            Parkourability parkourability = Parkourability.get((Player)player);
            if (parkourability == null) {
                return;
            }
            parkourability.getPermission().receiveServerPermissions(this);
            parkourability.getActionInfo().receiveServerPermissions(ByteBuffer.wrap(this.infoData));
        });
        contextSupplier.get().setPacketHandled(true);
    }

    private static ActionPermissionsMessage newInstance() {
        ActionPermissionsMessage message = new ActionPermissionsMessage();
        ParCoolConfig.Server config = ParCoolConfig.CONFIG_SERVER;
        message.allowedCatLeap = (Boolean)config.allowCatLeap.get();
        message.allowedCrawl = (Boolean)config.allowCrawl.get();
        message.allowedDodge = (Boolean)config.allowDodge.get();
        message.allowedFastRunning = (Boolean)config.allowFastRunning.get();
        message.allowedClingToCliff = (Boolean)config.allowClingToCliff.get();
        message.allowedRoll = (Boolean)config.allowRoll.get();
        message.allowedVault = (Boolean)config.allowVault.get();
        message.allowedWallJump = (Boolean)config.allowWallJump.get();
        message.allowedInfiniteStamina = (Boolean)config.allowInfiniteStamina.get();
        message.allowedFlipping = (Boolean)config.allowFlipping.get();
        message.allowedBreakfall = (Boolean)config.allowBreakfall.get();
        message.allowedWallSlide = (Boolean)config.allowWallSlide.get();
        message.allowedHorizontalWallRun = (Boolean)config.allowHorizontalWallRun.get();
        ByteBuffer buffer = ByteBuffer.allocate(128);
        ActionInfo.encode(buffer);
        buffer.flip();
        message.infoData = new byte[buffer.limit()];
        buffer.get(message.infoData);
        return message;
    }

    public static void send(ServerPlayer player) {
        ParCool.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)ActionPermissionsMessage.newInstance());
    }

    public static void broadcast() {
        ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)ActionPermissionsMessage.newInstance());
    }
}

