/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class StartBreakfallMessage {
    UUID playerID = null;

    public UUID getPlayerID() {
        return this.playerID;
    }

    public void encode(FriendlyByteBuf packet) {
        packet.writeLong(this.playerID.getMostSignificantBits());
        packet.writeLong(this.playerID.getLeastSignificantBits());
    }

    public static StartBreakfallMessage decode(FriendlyByteBuf packet) {
        StartBreakfallMessage message = new StartBreakfallMessage();
        message.playerID = new UUID(packet.readLong(), packet.readLong());
        return message;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)contextSupplier.get()).getNetworkManager().getDirection() == PacketFlow.CLIENTBOUND) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) {
                    return;
                }
                if (!this.playerID.equals(player.m_142081_())) {
                    return;
                }
                Parkourability parkourability = Parkourability.get((Player)player);
                if (parkourability == null) {
                    return;
                }
                Stamina stamina = Stamina.get((Player)player);
                if (stamina == null) {
                    return;
                }
                parkourability.getBreakfall().startBreakfall((Player)player, parkourability, stamina);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void handleServer(Supplier<NetworkEvent.Context> contextSupplier) {
    }

    public static void send(ServerPlayer player) {
        StartBreakfallMessage message = new StartBreakfallMessage();
        message.playerID = player.m_142081_();
        ParCool.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }
}

