/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.impl.Parkourability;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class StartVaultMessage {
    UUID playerID = null;

    public UUID getPlayerID() {
        return this.playerID;
    }

    public void encode(FriendlyByteBuf packet) {
        packet.writeLong(this.playerID.getMostSignificantBits());
        packet.writeLong(this.playerID.getLeastSignificantBits());
    }

    public static StartVaultMessage decode(FriendlyByteBuf packet) {
        StartVaultMessage message = new StartVaultMessage();
        message.playerID = new UUID(packet.readLong(), packet.readLong());
        return message;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)contextSupplier.get()).getNetworkManager().getDirection() == PacketFlow.CLIENTBOUND) {
                Parkourability parkourability;
                ServerPlayer player;
                if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    ClientLevel world = Minecraft.m_91087_().f_91073_;
                    if (world == null) {
                        return;
                    }
                    player = world.m_46003_(this.playerID);
                    if (player == null || player.m_7578_()) {
                        return;
                    }
                } else {
                    player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
                    ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)this);
                    if (player == null) {
                        return;
                    }
                }
                if ((parkourability = Parkourability.get((Player)player)) == null) {
                    return;
                }
                parkourability.getVault().receiveStartVault(this);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void handleServer(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)this));
    }

    public static void send(Player player) {
        StartVaultMessage message = new StartVaultMessage();
        message.playerID = player.m_142081_();
        ParCool.CHANNEL_INSTANCE.sendToServer((Object)message);
    }
}

