/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.impl.Stamina;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class SyncStaminaMessage {
    private int stamina = 0;
    private boolean exhausted = false;
    private UUID playerID = null;

    public int getStamina() {
        return this.stamina;
    }

    public boolean isExhausted() {
        return this.exhausted;
    }

    public void encode(FriendlyByteBuf packet) {
        packet.writeInt(this.stamina);
        packet.writeBoolean(this.exhausted);
        packet.writeLong(this.playerID.getMostSignificantBits());
        packet.writeLong(this.playerID.getLeastSignificantBits());
    }

    public static SyncStaminaMessage decode(FriendlyByteBuf packet) {
        SyncStaminaMessage message = new SyncStaminaMessage();
        message.stamina = packet.readInt();
        message.exhausted = packet.readBoolean();
        message.playerID = new UUID(packet.readLong(), packet.readLong());
        return message;
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void handleServer(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)this);
            if (player == null) {
                return;
            }
            Stamina stamina = Stamina.get((Player)player);
            if (stamina == null) {
                return;
            }
            stamina.synchronize(this);
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            Stamina stamina;
            ServerPlayer player;
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                if (world == null) {
                    return;
                }
                player = world.m_46003_(this.playerID);
                if (player == null || player.m_7578_()) {
                    return;
                }
            } else {
                player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
                ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)this);
                if (player == null) {
                    return;
                }
            }
            if ((stamina = Stamina.get((Player)player)) == null) {
                return;
            }
            stamina.synchronize(this);
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sync(Player player) {
        Stamina stamina = Stamina.get(player);
        if (stamina == null) {
            return;
        }
        SyncStaminaMessage message = new SyncStaminaMessage();
        message.stamina = stamina.getStamina();
        message.exhausted = stamina.isExhausted();
        message.playerID = player.m_142081_();
        ParCool.CHANNEL_INSTANCE.sendToServer((Object)message);
    }
}

