/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.MathUtil;
import net.minecraft.world.entity.player.Player;

public class SpeedVaultAnimator
extends Animator {
    private static final int MAX_TIME = 11;
    private Type type;

    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return this.getTick() >= 11;
    }

    @Override
    public void rotate(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        float phase = ((float)this.getTick() + rotator.getPartialTick()) / 11.0f;
        float factor = -MathUtil.squaring(((float)this.getTick() + rotator.getPartialTick() - 5.5f) / 5.5f) + 1.0f;
        float forwardFactor = (float)Math.sin((double)(phase * 2.0f) * Math.PI) + 0.5f;
        rotator.startBasedCenter().rotateRightward(factor * 70.0f * (float)(this.type == Type.Right ? -1 : 1)).rotateFrontward(30.0f * forwardFactor).end();
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        float phase = ((float)this.getTick() + transformer.getPartialTick()) / 11.0f;
        float factor = -MathUtil.squaring(((float)this.getTick() + transformer.getPartialTick() - 5.5f) / 5.5f) + 1.0f;
        switch (this.type) {
            case Right: {
                transformer.rotateLeftArm((float)Math.toRadians(MathUtil.lerp(-45.0f, 45.0f, phase)), 0.0f, (float)(-Math.toRadians(factor * 70.0f))).end();
                break;
            }
            case Left: {
                transformer.rotateRightArm((float)Math.toRadians(MathUtil.lerp(-45.0f, 45.0f, phase)), 0.0f, (float)Math.toRadians(factor * 70.0f)).end();
            }
        }
    }

    public SpeedVaultAnimator(Type type) {
        this.type = type;
    }

    public static enum Type {
        Right,
        Left;

    }
}

