/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.utilities.VectorUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class WallSlideAnimator
extends Animator {
    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return !parkourability.getWallSlide().isSliding();
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        Vec3 wall = parkourability.getWallSlide().getLeanedWallDirection();
        if (wall == null) {
            return;
        }
        Vec3 bodyVec = VectorUtil.fromYawDegree(player.f_20883_);
        Vec3 vec = new Vec3(bodyVec.m_7096_(), 0.0, bodyVec.m_7094_()).m_82541_();
        Vec3 dividedVec = new Vec3(vec.m_7096_() * wall.m_7096_() + vec.m_7094_() * wall.m_7094_(), 0.0, -vec.m_7096_() * wall.m_7094_() + vec.m_7094_() * wall.m_7096_()).m_82541_();
        if (dividedVec.m_7094_() < 0.0) {
            transformer.rotateRightArm((float)Math.toRadians(-160.0), (float)(-Math.toRadians(VectorUtil.toYawDegree(dividedVec) + 90.0)), 0.0f).end();
        } else {
            transformer.rotateLeftArm((float)Math.toRadians(-160.0), (float)(-Math.toRadians(VectorUtil.toYawDegree(dividedVec) + 90.0)), 0.0f).end();
        }
    }
}

