/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.hud;

import net.minecraft.util.Tuple;

public class Position {
    public static final Position DEFAULT = new Position(Horizontal.Left, Vertical.Top, 0, 0);
    private Horizontal alignmentHorizontal;
    private Vertical alignmentVertical;
    private int marginHorizontal;
    private int marginVertical;

    public Position(Horizontal alignH, Vertical alignV, int marginH, int marginV) {
        this.alignmentHorizontal = alignH;
        this.alignmentVertical = alignV;
        this.marginHorizontal = marginH;
        this.marginVertical = marginV;
    }

    public Tuple<Integer, Integer> calculate(int width, int height, int screenWidth, int screenHeight) {
        int x = this.alignmentHorizontal == Horizontal.Right ? screenWidth - this.marginHorizontal - width : this.marginHorizontal;
        int y = this.alignmentVertical == Vertical.Bottom ? screenHeight - this.marginVertical - height : this.marginVertical;
        return new Tuple((Object)x, (Object)y);
    }

    public void setAlignmentHorizontal(Horizontal alignmentHorizontal) {
        this.alignmentHorizontal = alignmentHorizontal;
    }

    public void setAlignmentVertical(Vertical alignmentVertical) {
        this.alignmentVertical = alignmentVertical;
    }

    public void setMarginHorizontal(int marginHorizontal) {
        this.marginHorizontal = marginHorizontal;
    }

    public void setMarginVertical(int marginVertical) {
        this.marginVertical = marginVertical;
    }

    public Horizontal getAlignmentHorizontal() {
        return this.alignmentHorizontal;
    }

    public Vertical getAlignmentVertical() {
        return this.alignmentVertical;
    }

    public int getMarginHorizontal() {
        return this.marginHorizontal;
    }

    public int getMarginVertical() {
        return this.marginVertical;
    }

    public static enum Horizontal {
        Left,
        Right;

    }

    public static enum Vertical {
        Top,
        Bottom;

    }
}

