/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.ClimbUpAnimator;
import com.alrex.parcool.client.animation.impl.ClingToCliffAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.EntityUtil;
import com.alrex.parcool.utilities.VectorUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class ClingToCliff
extends Action {
    private boolean cling = false;
    private int clingTick = 0;
    private int notClingTick = 0;
    private float armSwingAmountOld = 0.0f;
    private float armSwingAmount = 0.0f;

    public float getArmSwingAmount() {
        return this.armSwingAmount;
    }

    @Override
    public void onTick(Player player, Parkourability parkourability, Stamina stamina) {
        if (this.cling) {
            ++this.clingTick;
            this.notClingTick = 0;
            player.f_19789_ = 0.0f;
        } else {
            this.clingTick = 0;
            ++this.notClingTick;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canClimbUp(Player player, Parkourability parkourability, Stamina stamina) {
        return this.cling && parkourability.getPermission().canClingToCliff() && this.clingTick > 2 && KeyRecorder.keyJumpState.isPressed();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, Stamina stamina) {
        if (player.m_7578_()) {
            double ySpeed = player.m_20184_().m_7098_();
            boolean bl = this.cling = !stamina.isExhausted() && ySpeed < 0.2 && parkourability.getPermission().canClingToCliff() && KeyBindings.getKeyGrabWall().m_90857_() && WorldUtil.existsGrabbableWall((LivingEntity)player);
            if (this.canClimbUp(player, parkourability, stamina)) {
                this.cling = false;
                this.clingTick = 0;
                EntityUtil.addVelocity((Entity)player, new Vec3(0.0, 0.6, 0.0));
                stamina.consume(parkourability.getActionInfo().getStaminaConsumptionClimbUp(), player);
                Animation animation = Animation.get(player);
                if (animation != null) {
                    animation.setAnimator(new ClimbUpAnimator());
                }
            }
            if (this.cling) {
                stamina.consume(parkourability.getActionInfo().getStaminaConsumptionClingToCliff(), player);
                if (KeyBindings.getKeyLeft().m_90857_() && KeyBindings.getKeyRight().m_90857_()) {
                    player.m_20334_(0.0, 0.0, 0.0);
                } else {
                    Vec3 wallDirection = WorldUtil.getWall((LivingEntity)player);
                    if (wallDirection != null) {
                        Vec3 vec = wallDirection.m_82524_(1.5707964f).m_82541_().m_82490_(0.1);
                        if (KeyBindings.getKeyLeft().m_90857_()) {
                            player.m_20256_(vec);
                        } else if (KeyBindings.getKeyRight().m_90857_()) {
                            player.m_20256_(vec.m_82548_());
                        } else {
                            player.m_20334_(0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (this.cling) {
                this.armSwingAmount = (float)((double)this.armSwingAmount + player.m_20184_().m_82556_());
            }
        }
        this.armSwingAmountOld = this.armSwingAmount;
        if (this.cling) {
            Animation animation = Animation.get(player);
            if (animation != null) {
                animation.setAnimator(new ClingToCliffAnimator());
            }
        } else {
            this.armSwingAmount = 0.0f;
        }
    }

    @Override
    public void onRender(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
        Vec3 wall;
        if (this.cling && (wall = WorldUtil.getWall((LivingEntity)player)) != null) {
            float yRot = (float)VectorUtil.toYawDegree(wall.m_82541_());
            player.m_5618_(yRot);
            Vec3 vec = VectorUtil.fromYawDegree(player.f_20885_);
            Vec3 dividedVec = new Vec3(vec.m_7096_() * wall.m_7096_() + vec.m_7094_() * wall.m_7094_(), 0.0, -vec.m_7096_() * wall.m_7094_() + vec.m_7094_() * wall.m_7096_()).m_82541_();
            if (dividedVec.m_7096_() < 0.34202) {
                if (dividedVec.m_7094_() < 0.0) {
                    player.m_146922_((float)VectorUtil.toYawDegree(wall.m_82524_(1.2217305f)));
                } else {
                    player.m_146922_((float)VectorUtil.toYawDegree(wall.m_82524_(-1.2217305f)));
                }
            }
        }
    }

    @Override
    public void restoreState(ByteBuffer buffer) {
        this.cling = BufferUtil.getBoolean(buffer);
    }

    @Override
    public void saveState(ByteBuffer buffer) {
        BufferUtil.wrap(buffer).putBoolean(this.cling);
    }

    public boolean isCling() {
        return this.cling;
    }

    public int getClingTick() {
        return this.clingTick;
    }

    public int getNotClingTick() {
        return this.notClingTick;
    }
}

