/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.animation.impl.DodgeAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.EntityUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class Dodge
extends Action {
    private DodgeDirection dodgeDirection = null;
    private int coolTime = 0;
    private int dodgingTick = 0;
    private int damageCoolTime = 0;
    private boolean dodging = false;
    private int successivelyCount = 0;
    private int successivelyCoolTick = 0;

    public boolean isDodging() {
        return this.dodging;
    }

    @Override
    public void onTick(Player player, Parkourability parkourability, Stamina stamina) {
        if (this.coolTime > 0) {
            --this.coolTime;
        }
        if (this.successivelyCoolTick > 0) {
            --this.successivelyCoolTick;
        } else {
            this.successivelyCount = 0;
        }
        if (this.damageCoolTime > 0) {
            --this.damageCoolTime;
        }
        this.dodgingTick = this.dodging ? ++this.dodgingTick : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean canDodge(Player player, Parkourability parkourability, Stamina stamina) {
        boolean enabledDoubleTap = (Boolean)ParCoolConfig.CONFIG_CLIENT.disableDoubleTappingForDodge.get() == false;
        return parkourability.getPermission().canDodge() && this.successivelyCount < 2 && this.coolTime <= 0 && player.m_20096_() && !player.m_6144_() && !stamina.isExhausted() && !parkourability.getRoll().isRolling() && !parkourability.getTap().isTapping() && (enabledDoubleTap && (KeyRecorder.keyBack.isDoubleTapped() || KeyRecorder.keyLeft.isDoubleTapped() || KeyRecorder.keyRight.isDoubleTapped() || (Boolean)ParCoolConfig.CONFIG_CLIENT.canFrontDodgeByDoubleTap.get() != false && KeyRecorder.keyForward.isDoubleTapped()) || KeyBindings.getKeyDodge().m_90857_() && (KeyBindings.getKeyForward().m_90857_() || KeyBindings.getKeyBack().m_90857_() || KeyBindings.getKeyLeft().m_90857_() || KeyBindings.getKeyRight().m_90857_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean canContinue(Player player, Parkourability parkourability, Stamina stamina) {
        return this.dodging && !parkourability.getRoll().isRolling() && !parkourability.getClingToCliff().isCling() && !player.m_20096_() && !player.m_20072_() && !player.m_21255_() && !player.m_150110_().f_35935_ && parkourability.getPermission().canClingToCliff();
    }

    @OnlyIn(value=Dist.CLIENT)
    private DodgeDirection getDirectionFromInput() {
        if (KeyBindings.getKeyBack().m_90857_()) {
            return DodgeDirection.Back;
        }
        if (KeyBindings.getKeyForward().m_90857_()) {
            return DodgeDirection.Front;
        }
        if (KeyBindings.getKeyLeft().m_90857_()) {
            return DodgeDirection.Left;
        }
        return DodgeDirection.Right;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, Stamina stamina) {
        Animation animation;
        if (player.m_7578_()) {
            if (this.canContinue(player, parkourability, stamina)) {
                this.dodging = true;
            } else {
                this.dodgingTick = 0;
                this.dodging = false;
            }
            if (!this.dodging && this.canDodge(player, parkourability, stamina)) {
                this.dodging = true;
                stamina.consume(parkourability.getActionInfo().getStaminaConsumptionDodge(), player);
                this.dodgeDirection = this.getDirectionFromInput();
                Vec3 lookVec = player.m_20154_();
                lookVec = new Vec3(lookVec.m_7096_(), 0.0, lookVec.m_7094_()).m_82541_();
                double jump = 0.0;
                Vec3 dodgeVec = Vec3.f_82478_;
                switch (this.dodgeDirection) {
                    case Front: {
                        dodgeVec = lookVec;
                        break;
                    }
                    case Back: {
                        dodgeVec = lookVec.m_82548_();
                        break;
                    }
                    case Right: {
                        dodgeVec = lookVec.m_82524_(-1.5707964f);
                        break;
                    }
                    case Left: {
                        dodgeVec = lookVec.m_82524_(1.5707964f);
                    }
                }
                jump = 0.3;
                this.coolTime = 10;
                if (this.successivelyCoolTick != 0) {
                    ++this.successivelyCount;
                }
                this.successivelyCoolTick = 30;
                dodgeVec = dodgeVec.m_82490_(0.4);
                EntityUtil.addVelocity((Entity)player, new Vec3(dodgeVec.m_7096_(), jump, dodgeVec.m_7094_()));
            }
        }
        if (this.dodging && this.dodgingTick <= 1 && (animation = Animation.get(player)) != null) {
            animation.setAnimator(new DodgeAnimator());
        }
    }

    @Override
    public void onRender(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
    }

    @Override
    public void restoreState(ByteBuffer buffer) {
        this.dodging = BufferUtil.getBoolean(buffer);
        this.dodgeDirection = DodgeDirection.getFromCode(buffer.getInt());
    }

    @Override
    public void saveState(ByteBuffer buffer) {
        BufferUtil.wrap(buffer).putBoolean(this.dodging);
        buffer.putInt(this.dodgeDirection == null ? -1 : this.dodgeDirection.getCode());
    }

    public DodgeDirection getDodgeDirection() {
        return this.dodgeDirection;
    }

    public int getCoolTime() {
        return this.coolTime;
    }

    public int getDamageCoolTime() {
        return this.damageCoolTime;
    }

    public int getDodgingTick() {
        return this.dodgingTick;
    }

    public static enum DodgeDirection {
        Front,
        Back,
        Left,
        Right;


        int getCode() {
            switch (this) {
                case Front: {
                    return 0;
                }
                case Back: {
                    return 1;
                }
                case Left: {
                    return 2;
                }
                case Right: {
                    return 3;
                }
            }
            return -1;
        }

        @Nullable
        public static DodgeDirection getFromCode(int code) {
            switch (code) {
                case 0: {
                    return Front;
                }
                case 1: {
                    return Back;
                }
                case 2: {
                    return Left;
                }
                case 3: {
                    return Right;
                }
            }
            return null;
        }
    }
}

