/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.animation.impl.FastRunningAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.impl.AdditionalProperties;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import com.alrex.parcool.utilities.BufferUtil;
import java.nio.ByteBuffer;
import java.util.UUID;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class FastRun
extends Action {
    private static final String FAST_RUNNING_MODIFIER_NAME = "parcool.modifier.fastrunnning";
    private static final UUID FAST_RUNNING_MODIFIER_UUID = UUID.randomUUID();
    private static final AttributeModifier FAST_RUNNING_MODIFIER = new AttributeModifier(FAST_RUNNING_MODIFIER_UUID, "parcool.modifier.fastrunnning", (Double)ParCoolConfig.CONFIG_CLIENT.fastRunningModifier.get() / 100.0, AttributeModifier.Operation.ADDITION);
    private int runningTick = 0;
    private int notRunningTick = 0;
    private boolean fastRunning = false;

    @Override
    public void onTick(Player player, Parkourability parkourability, Stamina stamina) {
        if (this.fastRunning) {
            ++this.runningTick;
            this.notRunningTick = 0;
        } else {
            this.runningTick = 0;
            ++this.notRunningTick;
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, Stamina stamina) {
        AttributeInstance attr;
        if (player.m_7578_()) {
            boolean bl = this.fastRunning = parkourability.getPermission().canFastRunning() && !stamina.isExhausted() && player.m_20142_() && !player.m_20143_() && !player.m_6069_() && !parkourability.getCrawl().isCrawling() && (KeyBindings.getKeyFastRunning().m_90857_() || (Boolean)ParCoolConfig.CONFIG_CLIENT.replaceSprintWithFastRun.get() != false);
        }
        if ((attr = player.m_21051_(Attributes.f_22279_)) == null) {
            return;
        }
        if (this.isRunning()) {
            if (!attr.m_22109_(FAST_RUNNING_MODIFIER)) {
                attr.m_22118_(FAST_RUNNING_MODIFIER);
            }
            stamina.consume(parkourability.getActionInfo().getStaminaConsumptionFastRun(), player);
            Animation animation = Animation.get(player);
            if (animation != null && !animation.hasAnimator()) {
                animation.setAnimator(new FastRunningAnimator());
            }
        } else if (attr.m_22109_(FAST_RUNNING_MODIFIER)) {
            attr.m_22130_(FAST_RUNNING_MODIFIER);
        }
    }

    @Override
    public void onRender(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
    }

    @Override
    public void restoreState(ByteBuffer buffer) {
        this.fastRunning = BufferUtil.getBoolean(buffer);
    }

    @Override
    public void saveState(ByteBuffer buffer) {
        BufferUtil.wrap(buffer).putBoolean(this.fastRunning);
    }

    public int getRunningTick() {
        return this.runningTick;
    }

    public int getNotRunningTick() {
        return this.notRunningTick;
    }

    public boolean isRunning() {
        return this.fastRunning;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canActWithRunning(Player player) {
        return (Boolean)ParCoolConfig.CONFIG_CLIENT.substituteSprintForFastRun.get() != false ? player.m_20142_() : this.isRunning();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDashTick(AdditionalProperties properties) {
        return (Boolean)ParCoolConfig.CONFIG_CLIENT.substituteSprintForFastRun.get() != false ? properties.getSprintingTick() : this.getRunningTick();
    }
}

