/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.animation.impl.RollAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.VectorUtil;
import java.nio.ByteBuffer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class Roll
extends Action {
    private boolean start = false;
    private boolean rolling = false;
    private int rollingTick = 0;
    private int creativeCoolTime = 0;

    @Override
    public void onTick(Player player, Parkourability parkourability, Stamina stamina) {
        this.rollingTick = this.rolling ? ++this.rollingTick : 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, Stamina stamina) {
        Animation animation;
        if (player.m_7578_()) {
            if (KeyBindings.getKeyBreakfall().m_90857_() && KeyBindings.getKeyForward().m_90857_() && ((Boolean)ParCoolConfig.CONFIG_CLIENT.enableRollWhenCreative.get()).booleanValue() && player.m_7500_() && parkourability.getAdditionalProperties().getLandingTick() <= 1 && player.m_20096_() && !this.rolling && this.creativeCoolTime == 0) {
                this.start = true;
                this.creativeCoolTime = 20;
            }
            if (this.creativeCoolTime > 0) {
                --this.creativeCoolTime;
            }
            if (this.rollingTick >= this.getRollMaxTick()) {
                this.rolling = false;
            }
        }
        if ((this.rolling && this.rollingTick <= 1 || this.start) && (animation = Animation.get(player)) != null) {
            animation.setAnimator(new RollAnimator());
        }
        if (this.start) {
            this.start = false;
            this.rolling = true;
            if (player.m_7578_()) {
                Vec3 vec = VectorUtil.fromYawDegree(player.f_20883_);
                player.m_20334_(vec.m_7096_(), 0.0, vec.m_7094_());
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
    }

    public void startRoll(Player player) {
        this.start = true;
    }

    @Override
    public void saveState(ByteBuffer buffer) {
        BufferUtil.wrap(buffer).putBoolean(this.start).putBoolean(this.rolling);
    }

    @Override
    public void restoreState(ByteBuffer buffer) {
        this.start = BufferUtil.getBoolean(buffer);
        this.rolling = BufferUtil.getBoolean(buffer);
    }

    public int getRollingTick() {
        return this.rollingTick;
    }

    public boolean isRolling() {
        return this.rolling;
    }

    public int getRollMaxTick() {
        return 9;
    }
}

