/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.animation.impl.SpeedVaultAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.impl.Animation;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.alrex.parcool.common.capability.impl.Stamina;
import com.alrex.parcool.common.network.StartVaultMessage;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class Vault
extends Action {
    private boolean vauting = false;
    private int vaultingTick = 0;
    private double stepHeight = 0.0;
    private Vec3 stepDirection = null;
    private boolean start = false;

    @Override
    public void onTick(Player player, Parkourability parkourability, Stamina stamina) {
        this.vaultingTick = this.vauting ? ++this.vaultingTick : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean canVault(Player player, Parkourability parkourability, Stamina stamina) {
        Vec3 lookVec = player.m_20154_();
        lookVec = new Vec3(lookVec.m_7096_(), 0.0, lookVec.m_7094_()).m_82541_();
        Vec3 wall = WorldUtil.getWall((LivingEntity)player);
        if (wall == null) {
            return false;
        }
        return !this.vauting && parkourability.getPermission().canVault() && ((Boolean)ParCoolConfig.CONFIG_CLIENT.vaultNeedKeyPressed.get() == false || KeyBindings.getKeyVault().m_90857_()) && parkourability.getFastRun().canActWithRunning(player) && !stamina.isExhausted() && player.m_20096_() && wall.m_82526_(lookVec) / wall.m_82553_() / lookVec.m_82553_() > 0.707106 && WorldUtil.getVaultableStep((LivingEntity)player) != null && WorldUtil.getWallHeight((LivingEntity)player) > 0.8;
    }

    private int getVaultAnimateTime() {
        return 2;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, Stamina stamina) {
        if (this.start) {
            this.start = false;
            Animation animation = Animation.get(player);
            if (animation != null) {
                animation.setAnimator(new SpeedVaultAnimator(SpeedVaultAnimator.Type.Right));
            }
        }
        if (player.m_7578_()) {
            if (!this.isVaulting() && this.canVault(player, parkourability, stamina)) {
                SpeedVaultAnimator.Type type;
                this.vauting = true;
                this.vaultingTick = 0;
                this.stepDirection = WorldUtil.getVaultableStep((LivingEntity)player);
                this.stepHeight = WorldUtil.getWallHeight((LivingEntity)player);
                Vec3 lookVec = player.m_20154_();
                Vec3 vec = new Vec3(lookVec.m_7096_(), 0.0, lookVec.m_7094_()).m_82541_();
                Vec3 s = this.stepDirection;
                Vec3 dividedVec = new Vec3(vec.m_7096_() * s.m_7096_() + vec.m_7094_() * s.m_7094_(), 0.0, -vec.m_7096_() * s.m_7094_() + vec.m_7094_() * s.m_7096_());
                stamina.consume(parkourability.getActionInfo().getStaminaConsumptionVault(), player);
                Animation animation = Animation.get(player);
                SpeedVaultAnimator.Type type2 = type = dividedVec.m_7094_() > 0.0 ? SpeedVaultAnimator.Type.Right : SpeedVaultAnimator.Type.Left;
                if (animation != null) {
                    animation.setAnimator(new SpeedVaultAnimator(type));
                }
                StartVaultMessage.send(player);
            }
            if (this.vauting) {
                player.m_20334_(this.stepDirection.m_7096_() / 10.0, (this.stepHeight + 0.05) / (double)this.getVaultAnimateTime(), this.stepDirection.m_7094_() / 10.0);
            }
            if (this.vaultingTick >= this.getVaultAnimateTime()) {
                this.vauting = false;
                this.stepDirection = this.stepDirection.m_82541_();
                player.m_20334_(this.stepDirection.m_7096_() * 0.45, 0.15, this.stepDirection.m_7094_() * 0.45);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRender(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
    }

    @Override
    public void restoreState(ByteBuffer buffer) {
    }

    public void receiveStartVault(StartVaultMessage message) {
        this.start = true;
    }

    @Override
    public void saveState(ByteBuffer buffer) {
    }

    public boolean isVaulting() {
        return this.vauting;
    }

    public int getVaultingTick() {
        return this.vaultingTick;
    }
}

