/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.constants.ActionsEnum;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ShowActionPossibilityMessage {
    ActionsEnum action = null;

    public void encode(FriendlyByteBuf packet) {
        packet.writeBoolean(this.action != null);
        if (this.action != null) {
            packet.m_130070_(this.action.name());
        }
    }

    public static ShowActionPossibilityMessage decode(FriendlyByteBuf packet) {
        ShowActionPossibilityMessage message = new ShowActionPossibilityMessage();
        try {
            if (packet.readBoolean()) {
                message.action = ActionsEnum.valueOf(packet.m_130277_());
            }
        }
        catch (IllegalArgumentException e) {
            message.action = null;
        }
        return message;
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            player.m_5661_((Component)new TextComponent(ShowActionPossibilityMessage.getText(this.action)), false);
        });
        contextSupplier.get().setPacketHandled(true);
    }

    private static String getText(ActionsEnum action) {
        ParCoolConfig.Client c = ParCoolConfig.CONFIG_CLIENT;
        if (action != null) {
            switch (action) {
                case CatLeap: {
                    return action.name() + " : " + ((Boolean)c.canCatLeap.get()).toString();
                }
                case Crawl: {
                    return action.name() + " : " + ((Boolean)c.canCrawl.get()).toString();
                }
                case Dodge: {
                    return action.name() + " : " + ((Boolean)c.canDodge.get()).toString();
                }
                case FastRunning: {
                    return action.name() + " : " + ((Boolean)c.canFastRunning.get()).toString();
                }
                case GrabCliff: {
                    return action.name() + " : " + ((Boolean)c.canClingToCliff.get()).toString();
                }
                case Roll: {
                    return action.name() + " : " + ((Boolean)c.canRoll.get()).toString();
                }
                case Vault: {
                    return action.name() + " : " + ((Boolean)c.canVault.get()).toString();
                }
                case WallJump: {
                    return action.name() + " : " + ((Boolean)c.canWallJump.get()).toString();
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append(ActionsEnum.CatLeap.name()).append(" : ").append(((Boolean)c.canCatLeap.get()).toString()).append('\n').append(ActionsEnum.Crawl.name()).append(" : ").append(((Boolean)c.canCrawl.get()).toString()).append('\n').append(ActionsEnum.Dodge.name()).append(" : ").append(((Boolean)c.canDodge.get()).toString()).append('\n').append(ActionsEnum.FastRunning.name()).append(" : ").append(((Boolean)c.canFastRunning.get()).toString()).append('\n').append(ActionsEnum.GrabCliff.name()).append(" : ").append(((Boolean)c.canClingToCliff.get()).toString()).append('\n').append(ActionsEnum.Roll.name()).append(" : ").append(((Boolean)c.canRoll.get()).toString()).append('\n').append(ActionsEnum.Vault.name()).append(" : ").append(((Boolean)c.canVault.get()).toString()).append('\n').append(ActionsEnum.WallJump.name()).append(" : ").append(((Boolean)c.canWallJump.get()).toString());
        return builder.toString();
    }

    public static void send(ServerPlayer player, ActionsEnum action) {
        ShowActionPossibilityMessage message = new ShowActionPossibilityMessage();
        message.action = action;
        ParCool.CHANNEL_INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }
}

