/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.impl.AdditionalProperties;
import com.alrex.parcool.common.action.impl.Breakfall;
import com.alrex.parcool.common.action.impl.CatLeap;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.Dodge;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.action.impl.Flipping;
import com.alrex.parcool.common.action.impl.HorizontalWallRun;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.action.impl.Tap;
import com.alrex.parcool.common.action.impl.Vault;
import com.alrex.parcool.common.action.impl.WallJump;
import com.alrex.parcool.common.action.impl.WallSlide;
import com.alrex.parcool.common.capability.impl.Parkourability;
import com.mojang.datafixers.util.Pair;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncActionStateMessage {
    private byte classNumber = (byte)-1;
    private UUID senderUUID = null;
    private byte[] buffer = null;

    private SyncActionStateMessage() {
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeByte((int)this.classNumber).writeLong(this.senderUUID.getMostSignificantBits()).writeLong(this.senderUUID.getLeastSignificantBits()).writeInt(this.buffer.length).writeBytes(this.buffer);
    }

    public static SyncActionStateMessage decode(FriendlyByteBuf packetBuffer) {
        SyncActionStateMessage message = new SyncActionStateMessage();
        message.classNumber = packetBuffer.readByte();
        message.senderUUID = new UUID(packetBuffer.readLong(), packetBuffer.readLong());
        int size = packetBuffer.readInt();
        message.buffer = new byte[size];
        packetBuffer.readBytes(message.buffer);
        return message;
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void handleServer(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)this);
            if (player == null) {
                return;
            }
            Parkourability parkourability = Parkourability.get((Player)player);
            if (parkourability == null) {
                return;
            }
            Decoder decoder = new Decoder(this.buffer, parkourability);
            while (decoder.hasNext()) {
                Pair<Action, ByteBuffer> item = decoder.getItem();
                ((Action)item.getFirst()).restoreState((ByteBuffer)item.getSecond());
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            Parkourability parkourability;
            ServerPlayer player;
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                ClientLevel world = Minecraft.m_91087_().f_91073_;
                if (world == null) {
                    return;
                }
                player = world.m_46003_(this.senderUUID);
                if (player == null || player.m_7578_()) {
                    return;
                }
            } else {
                player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
                ParCool.CHANNEL_INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)this);
                if (player == null) {
                    return;
                }
            }
            if ((parkourability = Parkourability.get((Player)player)) == null) {
                return;
            }
            Decoder decoder = new Decoder(this.buffer, parkourability);
            while (decoder.hasNext()) {
                Pair<Action, ByteBuffer> item = decoder.getItem();
                if (item.getFirst() == null) continue;
                ((Action)item.getFirst()).restoreState((ByteBuffer)item.getSecond());
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }

    private static byte getClassNumber(Action action) {
        if (action instanceof AdditionalProperties) {
            return 0;
        }
        if (action instanceof CatLeap) {
            return 1;
        }
        if (action instanceof ClingToCliff) {
            return 2;
        }
        if (action instanceof Crawl) {
            return 3;
        }
        if (action instanceof Dodge) {
            return 4;
        }
        if (action instanceof FastRun) {
            return 5;
        }
        if (action instanceof Roll) {
            return 6;
        }
        if (action instanceof Vault) {
            return 7;
        }
        if (action instanceof WallJump) {
            return 8;
        }
        if (action instanceof Breakfall) {
            return 9;
        }
        if (action instanceof Tap) {
            return 10;
        }
        if (action instanceof Flipping) {
            return 11;
        }
        if (action instanceof WallSlide) {
            return 12;
        }
        if (action instanceof HorizontalWallRun) {
            return 13;
        }
        return -1;
    }

    @Nullable
    private static Action getActionCorrespondingClassNumber(Parkourability parkourability, byte classNumber) {
        switch (classNumber) {
            case 0: {
                return parkourability.getAdditionalProperties();
            }
            case 1: {
                return parkourability.getCatLeap();
            }
            case 2: {
                return parkourability.getClingToCliff();
            }
            case 3: {
                return parkourability.getCrawl();
            }
            case 4: {
                return parkourability.getDodge();
            }
            case 5: {
                return parkourability.getFastRun();
            }
            case 6: {
                return parkourability.getRoll();
            }
            case 7: {
                return parkourability.getVault();
            }
            case 8: {
                return parkourability.getWallJump();
            }
            case 9: {
                return parkourability.getBreakfall();
            }
            case 10: {
                return parkourability.getTap();
            }
            case 11: {
                return parkourability.getFlipping();
            }
            case 12: {
                return parkourability.getWallSlide();
            }
            case 13: {
                return parkourability.getHorizontalWallRun();
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sync(Player player, Builder builder) {
        ByteBuffer buffer1 = builder.build();
        if (buffer1.limit() == 0) {
            return;
        }
        SyncActionStateMessage message = new SyncActionStateMessage();
        message.senderUUID = player.m_142081_();
        message.buffer = new byte[buffer1.limit()];
        buffer1.get(message.buffer);
        ParCool.CHANNEL_INSTANCE.sendToServer((Object)message);
    }

    public static class Builder {
        private static final Builder instance = new Builder();
        private static final Builder sub = new Builder();
        private final ByteBuffer buffer = ByteBuffer.allocate(1024);

        private Builder() {
        }

        public static Builder main() {
            Builder.instance.buffer.clear();
            return instance;
        }

        public static Builder sub() {
            Builder.sub.buffer.clear();
            return sub;
        }

        public Builder append(Action action, ByteBuffer actionBuffer) {
            this.buffer.put(SyncActionStateMessage.getClassNumber(action)).putInt(actionBuffer.limit()).put(actionBuffer);
            return this;
        }

        public ByteBuffer build() {
            this.buffer.flip();
            return this.buffer;
        }
    }

    private static class Decoder {
        ByteBuffer buffer;
        Parkourability parkourability;

        Decoder(byte[] buf, Parkourability parkourability) {
            this.buffer = ByteBuffer.wrap(buf);
            this.parkourability = parkourability;
        }

        public boolean hasNext() {
            return this.buffer.position() < this.buffer.limit();
        }

        public Pair<Action, ByteBuffer> getItem() {
            Action action = SyncActionStateMessage.getActionCorrespondingClassNumber(this.parkourability, this.buffer.get());
            byte[] array = new byte[this.buffer.getInt()];
            this.buffer.get(array);
            ByteBuffer buf = ByteBuffer.wrap(array);
            return new Pair((Object)action, (Object)buf);
        }
    }
}

