/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.extern.feathers;

import com.alrex.parcool.common.capability.IStamina;
import com.elenai.feathers.api.FeathersHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class FeathersStamina
implements IStamina {
    private static final int MAX_FEATHERS = 20;
    private final Player player;
    private int old;
    private float fraction = 0.0f;

    public FeathersStamina(Player player) {
        this.player = player;
    }

    @Override
    public int getActualMaxStamina() {
        return 20;
    }

    @Override
    public int get() {
        if (this.player.m_7578_()) {
            return FeathersHelper.getFeathers();
        }
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return FeathersHelper.getFeathers((ServerPlayer)serverPlayer);
        }
        return 1;
    }

    @Override
    public int getOldValue() {
        return this.old;
    }

    @Override
    public void consume(int value) {
        if (this.player.m_7578_()) {
            int spentFeathers = value / 100;
            this.fraction += (float)value / 100.0f - (float)spentFeathers;
            FeathersHelper.spendFeathers((int)spentFeathers);
            if (this.fraction >= 1.0f) {
                this.fraction -= 1.0f;
                FeathersHelper.spendFeathers((int)1);
            }
        }
    }

    @Override
    public void recover(int value) {
        this.fraction -= (float)value / 100.0f;
        if (this.fraction < 0.0f) {
            this.fraction = 0.0f;
        }
    }

    @Override
    public boolean isExhausted() {
        return this.player.m_7578_() && !FeathersHelper.checkFeathersRemaining();
    }

    @Override
    public void setExhaustion(boolean value) {
    }

    @Override
    public void tick() {
        this.old = this.get();
    }

    @Override
    public void set(int value) {
    }
}

