/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.server.command.args;

import com.alrex.parcool.config.ParCoolConfig;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;

public class LimitationItemArgumentType
implements ArgumentType<Object> {
    private final List<String> paths;
    private final Object[] enumConstants;
    private final Class<?> clazz;

    public Object parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readUnquotedString();
        int index = this.paths.indexOf(name);
        if (index == -1) {
            TranslatableComponent message = new TranslatableComponent("parcool.command.message.invalidConfigName", new Object[]{name});
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)message), (Message)message);
        }
        return this.enumConstants[index];
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String remain = builder.getRemaining();
        for (String name : this.paths.stream().filter(it -> it.startsWith(remain)).collect(Collectors.toList())) {
            builder.suggest(name);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return this.paths;
    }

    LimitationItemArgumentType(Class<?> clazz) {
        this.clazz = clazz;
        this.enumConstants = clazz.getEnumConstants();
        this.paths = new ArrayList<String>(this.enumConstants.length);
        for (Object enumConstant : this.enumConstants) {
            ParCoolConfig.Item item = (ParCoolConfig.Item)enumConstant;
            this.paths.add(item.getPath());
        }
    }

    public static LimitationItemArgumentType booleans() {
        return new LimitationItemArgumentType(ParCoolConfig.Server.Booleans.class);
    }

    public static LimitationItemArgumentType integers() {
        return new LimitationItemArgumentType(ParCoolConfig.Server.Integers.class);
    }

    public static LimitationItemArgumentType doubles() {
        return new LimitationItemArgumentType(ParCoolConfig.Server.Doubles.class);
    }

    public static ParCoolConfig.Server.Booleans getBool(CommandContext<?> context, String name) {
        return (ParCoolConfig.Server.Booleans)context.getArgument(name, ParCoolConfig.Server.Booleans.class);
    }

    public static ParCoolConfig.Server.Integers getInt(CommandContext<?> context, String name) {
        return (ParCoolConfig.Server.Integers)context.getArgument(name, ParCoolConfig.Server.Integers.class);
    }

    public static ParCoolConfig.Server.Doubles getDouble(CommandContext<?> context, String name) {
        return (ParCoolConfig.Server.Doubles)context.getArgument(name, ParCoolConfig.Server.Doubles.class);
    }

    public static class Serializer
    implements ArgumentSerializer<LimitationItemArgumentType> {
        @Nonnull
        public LimitationItemArgumentType deserializeFromNetwork(FriendlyByteBuf buffer) {
            String typeName = buffer.m_130277_();
            if (typeName.equals(ParCoolConfig.Server.Booleans.class.getTypeName())) {
                return LimitationItemArgumentType.booleans();
            }
            if (typeName.equals(ParCoolConfig.Server.Integers.class.getTypeName())) {
                return LimitationItemArgumentType.integers();
            }
            if (typeName.equals(ParCoolConfig.Server.Doubles.class.getTypeName())) {
                return LimitationItemArgumentType.doubles();
            }
            throw new IllegalArgumentException(String.format("No such Limitation type[%s]", typeName));
        }

        public void serializeToNetwork(LimitationItemArgumentType instance, FriendlyByteBuf buffer) {
            buffer.m_130070_(instance.clazz.getTypeName());
        }

        public void serializeToJson(LimitationItemArgumentType instance, JsonObject json) {
            json.addProperty("type", instance.clazz.getTypeName());
        }
    }
}

