/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.CrawlAnimator;
import com.alrex.parcool.client.animation.impl.SlidingAnimator;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.Crawl;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.action.impl.Tap;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Slide
extends Action {
    private Vec3 slidingVec = null;

    @Override
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        Vec3 lookingVec = player.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_();
        startInfo.putDouble(lookingVec.m_7096_()).putDouble(lookingVec.m_7094_());
        return !stamina.isExhausted() && KeyRecorder.keyCrawlState.isPressed() && player.m_20096_() && !parkourability.get(Roll.class).isDoing() && !parkourability.get(Tap.class).isDoing() && parkourability.get(Crawl.class).isDoing() && !player.m_20072_() && parkourability.get(FastRun.class).getDashTick(parkourability.getAdditionalProperties()) > 5;
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        int maxSlidingTick = Math.min(parkourability.getActionInfo().getClientSetting().get(ParCoolConfig.Client.Integers.SlidingContinuableTick), parkourability.getActionInfo().getServerLimitation().get(ParCoolConfig.Server.Integers.MaxSlidingContinuableTick));
        return this.getDoingTick() < maxSlidingTick && parkourability.get(Crawl.class).isDoing();
    }

    @Override
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        Animation animation;
        this.slidingVec = new Vec3(startData.getDouble(), 0.0, startData.getDouble());
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.SLIDE.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new SlidingAnimator());
        }
        parkourability.getCancelMarks().addMarkerCancellingJump(this::isDoing);
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        Animation animation;
        this.slidingVec = new Vec3(startData.getDouble(), 0.0, startData.getDouble());
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.SLIDE.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new SlidingAnimator());
        }
    }

    @Override
    public void onWorkingTickInLocalClient(Player player, Parkourability parkourability, IStamina stamina) {
        if (this.slidingVec != null) {
            AttributeInstance attr = player.m_21051_(Attributes.f_22279_);
            double speedScale = 0.45;
            if (attr != null) {
                speedScale = attr.m_22135_() * 4.5;
            }
            Vec3 vec = this.slidingVec.m_82490_(speedScale);
            player.m_20256_((player.m_20096_() ? vec : vec.m_82490_(0.6)).m_82520_(0.0, player.m_20184_().m_7098_(), 0.0));
        }
    }

    @Override
    public void onWorkingTickInClient(Player player, Parkourability parkourability, IStamina stamina) {
        this.spawnSlidingParticle(player);
    }

    @Override
    public void onStopInLocalClient(Player player) {
        Animation animation = Animation.get(player);
        if (animation != null && !animation.hasAnimator()) {
            animation.setAnimator(new CrawlAnimator());
        }
    }

    @Override
    public void onStopInOtherClient(Player player) {
        Animation animation = Animation.get(player);
        if (animation != null && !animation.hasAnimator()) {
            animation.setAnimator(new CrawlAnimator());
        }
    }

    @Nullable
    public Vec3 getSlidingVector() {
        return this.slidingVec;
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.None;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnSlidingParticle(Player player) {
        Level level = player.f_19853_;
        Vec3 pos = player.m_20182_();
        BlockState feetBlock = player.f_19853_.m_8055_(player.m_20183_().m_7495_());
        float width = player.m_20205_();
        Vec3 direction = this.getSlidingVector();
        if (direction == null) {
            return;
        }
        if (feetBlock.m_60799_() != RenderShape.INVISIBLE) {
            Vec3 particlePos = new Vec3(pos.m_7096_() + (player.m_217043_().m_188500_() - 0.5) * (double)width, pos.m_7098_() + 0.01 + 0.2 * player.m_217043_().m_188500_(), pos.m_7094_() + (player.m_217043_().m_188500_() - 0.5) * (double)width);
            Vec3 particleSpeed = direction.m_82548_().m_82490_(2.5 + 5.0 * player.m_217043_().m_188500_()).m_82520_(0.0, 1.5, 0.0);
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, feetBlock).setPos(new BlockPos(player.m_20182_().m_82520_(0.0, -0.5, 0.0))), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), particleSpeed.m_7096_(), particleSpeed.m_7098_(), particleSpeed.m_7094_());
        }
    }
}

