/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.extern.epicfight;

import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.extern.epicfight.EpicFightStamina;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class EpicFightManager {
    private static boolean modInstalled = false;

    public static boolean isEpicFightInstalled() {
        return modInstalled;
    }

    public static void init() {
        IModFileInfo mod = ModList.get().getModFileById("epicfight");
        modInstalled = mod != null;
    }

    public static IStamina newFeathersStaminaFor(Player player) {
        if (!modInstalled) {
            return IStamina.Type.Default.newInstance(player);
        }
        return new EpicFightStamina(player);
    }

    @Nullable
    static PlayerPatch<?> getPlayerPatch(Player player) {
        if (!EpicFightManager.isEpicFightInstalled()) {
            return null;
        }
        return (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
    }

    public static boolean isBattleMode(Player player) {
        PlayerPatch<?> patch = EpicFightManager.getPlayerPatch(player);
        if (patch == null) {
            return false;
        }
        return patch.isBattleMode();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isUsingEpicFightStamina(Player player) {
        return IStamina.get(player) instanceof EpicFightStamina && EpicFightManager.isBattleMode(player);
    }
}

