/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.gui;

import com.alrex.parcool.client.gui.ColorTheme;
import com.alrex.parcool.client.gui.ParCoolSettingScreen;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.ActionList;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.common.network.SyncClientInformationMessage;
import com.alrex.parcool.config.ParCoolConfig;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.common.ForgeConfigSpec;

public class SettingActionLimitationScreen
extends ParCoolSettingScreen {
    private final ActionConfigSet[] actionList = new ActionConfigSet[ActionList.ACTIONS.size()];
    private final Checkbox[] actionButtons = new Checkbox[this.actionList.length];

    public SettingActionLimitationScreen(Component titleIn, ActionInfo info, ColorTheme theme) {
        super(titleIn, info, theme);
        this.currentScreen = 0;
        for (int i = 0; i < this.actionList.length; ++i) {
            this.actionList[i] = new ActionConfigSet(ActionList.getByIndex(i), info);
            this.actionButtons[i] = new Checkbox(0, 0, 0, 21, (Component)Component.m_237113_((String)this.actionList[i].name), this.actionList[i].getter.getAsBoolean());
        }
    }

    @Override
    public boolean isDownScrollable() {
        return this.topIndex + this.viewableItemCount < this.actionButtons.length;
    }

    @Override
    public void renderContents(PoseStack poseStack, int mouseX, int mouseY, float partialTick, int topOffset, int bottomOffset) {
        int offsetX = 40;
        Objects.requireNonNull(this.f_96547_);
        int headerHeight = (int)(9.0f * 1.5f);
        int contentOffsetY = topOffset + headerHeight + 2;
        int permissionColumnWidth = this.f_96547_.m_92852_((FormattedText)Permission_Permitted) * 5;
        int nameColumnWidth = this.f_96543_ - 80 - permissionColumnWidth * 2;
        int contentHeight = this.f_96544_ - contentOffsetY - bottomOffset;
        this.viewableItemCount = contentHeight / 21;
        int n = topOffset + headerHeight / 2;
        Objects.requireNonNull(this.f_96547_);
        int headerTextY = n - 9 / 2 + 1;
        SettingActionLimitationScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Header_ActionName, (int)45, (int)headerTextY, (int)this.color.getText());
        SettingActionLimitationScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Header_ServerPermission, (int)(40 + nameColumnWidth + permissionColumnWidth / 2), (int)headerTextY, (int)this.color.getText());
        SettingActionLimitationScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)Header_IndividualPermission, (int)(40 + nameColumnWidth + permissionColumnWidth + permissionColumnWidth / 2), (int)headerTextY, (int)this.color.getText());
        for (Checkbox actionButton : this.actionButtons) {
            actionButton.m_93674_(0);
        }
        for (int i = 0; i < this.viewableItemCount && i + this.topIndex < this.actionButtons.length; ++i) {
            Checkbox button = this.actionButtons[i + this.topIndex];
            button.m_252865_(41);
            button.m_252888_(contentOffsetY + 21 * i);
            button.m_93674_(nameColumnWidth - 5);
            button.setHeight(20);
            button.m_86412_(poseStack, mouseX, mouseY, partialTick);
            SettingActionLimitationScreen.m_93172_((PoseStack)poseStack, (int)40, (int)(button.m_252907_() + button.m_93694_()), (int)(this.f_96543_ - 40), (int)(button.m_252907_() + button.m_93694_() + 1), (int)this.color.getSubSeparator());
            int rowY = contentOffsetY + 21 * i + 10;
            boolean permitted = this.actionList[this.topIndex + i].serverWideLimitation.getAsBoolean();
            Component component = permitted ? Permission_Permitted : Permission_Denied;
            int n2 = 40 + nameColumnWidth + permissionColumnWidth / 2;
            Objects.requireNonNull(this.f_96547_);
            SettingActionLimitationScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)component, (int)n2, (int)(rowY - 9 / 2), (int)(permitted ? 43520 : 0xAA0000));
            permitted = this.actionList[this.topIndex + i].individualLimitation.getAsBoolean();
            Component component2 = permitted ? Permission_Permitted : Permission_Denied;
            int n3 = 40 + nameColumnWidth + permissionColumnWidth + permissionColumnWidth / 2;
            Objects.requireNonNull(this.f_96547_);
            SettingActionLimitationScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)component2, (int)n3, (int)(rowY - 9 / 2), (int)(permitted ? 43520 : 0xAA0000));
        }
        SettingActionLimitationScreen.m_93172_((PoseStack)poseStack, (int)40, (int)contentOffsetY, (int)(this.f_96543_ - 40), (int)(contentOffsetY - 1), (int)this.color.getSeparator());
        SettingActionLimitationScreen.m_93172_((PoseStack)poseStack, (int)40, (int)topOffset, (int)41, (int)(this.f_96544_ - bottomOffset), (int)this.color.getSeparator());
        SettingActionLimitationScreen.m_93172_((PoseStack)poseStack, (int)(40 + nameColumnWidth), (int)topOffset, (int)(40 + nameColumnWidth + 1), (int)(this.f_96544_ - bottomOffset), (int)this.color.getSeparator());
        SettingActionLimitationScreen.m_93172_((PoseStack)poseStack, (int)(40 + nameColumnWidth + permissionColumnWidth), (int)topOffset, (int)(40 + nameColumnWidth + permissionColumnWidth + 1), (int)(this.f_96544_ - bottomOffset), (int)this.color.getSeparator());
        SettingActionLimitationScreen.m_93172_((PoseStack)poseStack, (int)(40 + nameColumnWidth + permissionColumnWidth * 2), (int)topOffset, (int)(40 + nameColumnWidth + permissionColumnWidth * 2 + 1), (int)(this.f_96544_ - bottomOffset), (int)this.color.getSeparator());
        int columnCenter = 40 + nameColumnWidth + permissionColumnWidth / 2;
        if (topOffset < mouseY && mouseY < topOffset + headerHeight && columnCenter - permissionColumnWidth / 2 < mouseX && mouseX < columnCenter + permissionColumnWidth / 2) {
            this.m_96597_(poseStack, Collections.singletonList(Header_ServerPermissionText), mouseX, mouseY);
        }
        columnCenter = 40 + nameColumnWidth + permissionColumnWidth + permissionColumnWidth / 2;
        if (topOffset < mouseY && mouseY < topOffset + headerHeight && columnCenter - permissionColumnWidth / 2 < mouseX && mouseX < columnCenter + permissionColumnWidth / 2) {
            this.m_96597_(poseStack, Collections.singletonList(Header_IndividualPermissionText), mouseX, mouseY);
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int type) {
        for (Checkbox button : this.actionButtons) {
            if (!button.m_6375_(mouseX, mouseY, type)) continue;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, type);
    }

    @Override
    protected void save() {
        for (int i = 0; i < this.actionList.length; ++i) {
            this.actionList[i].setter.accept(this.actionButtons[i].m_93840_());
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        SyncClientInformationMessage.sync(player, true);
    }

    private static class ActionConfigSet {
        final String name;
        final Consumer<Boolean> setter;
        final BooleanSupplier getter;
        final BooleanSupplier serverWideLimitation;
        final BooleanSupplier individualLimitation;

        ActionConfigSet(Class<? extends Action> action, ActionInfo info) {
            this.name = Component.m_237115_((String)("parcool.action." + action.getSimpleName())).getString();
            ForgeConfigSpec.BooleanValue config = ParCoolConfig.Client.getPossibilityOf(action);
            this.setter = arg_0 -> ((ForgeConfigSpec.BooleanValue)config).set(arg_0);
            this.getter = () -> ((ForgeConfigSpec.BooleanValue)config).get();
            this.serverWideLimitation = () -> info.getServerLimitation().isPermitted(action);
            this.individualLimitation = () -> info.getIndividualLimitation().isPermitted(action);
        }
    }
}

