/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.info;

import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.info.ClientInformation;
import com.alrex.parcool.common.info.Limitations;
import com.alrex.parcool.config.ParCoolConfig;
import net.minecraft.nbt.Tag;

public class ActionInfo {
    private final Limitations[] Limitations = new Limitations[]{new Limitations(), new Limitations()};
    private final ClientInformation clientInformation = new ClientInformation();

    public Limitations getServerLimitation() {
        return this.Limitations[0];
    }

    public Limitations getIndividualLimitation() {
        return this.Limitations[1];
    }

    public ClientInformation getClientInformation() {
        return this.clientInformation;
    }

    public boolean can(Class<? extends Action> action) {
        for (Limitations limitation : this.Limitations) {
            if (limitation.isPermitted(action)) continue;
            return false;
        }
        return this.getClientInformation().get(ParCoolConfig.Client.Booleans.ParCoolIsActive) != false && this.getClientInformation().getPossibilityOf(action);
    }

    public int getStaminaConsumptionOf(Class<? extends Action> action) {
        int value = this.getClientInformation().getStaminaConsumptionOf(action);
        for (Limitations limitation : this.Limitations) {
            if (!limitation.isEnabled()) continue;
            value = Math.max(value, limitation.getLeastStaminaConsumption(action));
        }
        return value;
    }

    public int getStaminaRecoveryLimit() {
        int value = Integer.MAX_VALUE;
        for (Limitations limitation : this.Limitations) {
            if (!limitation.isEnabled()) continue;
            value = Math.min(value, limitation.get(ParCoolConfig.Server.Integers.MaxStaminaRecovery));
        }
        return value;
    }

    public int getMaxStaminaLimit() {
        int value = Integer.MAX_VALUE;
        for (Limitations limitation : this.Limitations) {
            if (!limitation.isEnabled()) continue;
            value = Math.min(value, limitation.get(ParCoolConfig.Server.Integers.MaxStaminaLimit));
        }
        return value;
    }

    public boolean isStaminaInfinite(boolean creativeOrSpectator) {
        if (this.getClientInformation().get(ParCoolConfig.Client.Booleans.InfiniteStamina).booleanValue() && this.isInfiniteStaminaPermitted()) {
            return true;
        }
        return creativeOrSpectator && this.getClientInformation().get(ParCoolConfig.Client.Booleans.InfiniteStaminaWhenCreative) != false;
    }

    public boolean isInfiniteStaminaPermitted() {
        for (Limitations limitation : this.Limitations) {
            if (limitation.isInfiniteStaminaPermitted()) continue;
            return false;
        }
        return true;
    }

    public void readTag(Tag inbt) {
        this.getIndividualLimitation().readTag(inbt);
    }

    public Tag writeTag() {
        return this.getIndividualLimitation().writeTag();
    }
}

