/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.mixin.client;

import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.config.ParCoolConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public abstract class PlayerModelMixin<T extends LivingEntity>
extends HumanoidModel<T> {
    @Shadow
    @Final
    private boolean f_103380_;
    @Shadow
    @Final
    public ModelPart f_103378_;
    @Shadow
    @Final
    public ModelPart f_103377_;
    @Shadow
    @Final
    public ModelPart f_103375_;
    @Shadow
    @Final
    public ModelPart f_103376_;
    @Shadow
    @Final
    public ModelPart f_103374_;
    @Shadow
    @Final
    private ModelPart f_103379_;
    private PlayerModelTransformer transformer = null;

    public PlayerModelMixin(ModelPart p_i1148_1_) {
        super(p_i1148_1_);
    }

    @Inject(method={"Lnet/minecraft/client/model/PlayerModel;setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onSetupAnimHead(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo info) {
        if (!(entity instanceof Player)) {
            return;
        }
        PlayerModel model = (PlayerModel)this;
        Player player = (Player)entity;
        if (player.m_7578_() && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && !ParCoolConfig.Client.Booleans.EnableFPVAnimation.get().booleanValue()) {
            return;
        }
        this.transformer = new PlayerModelTransformer(player, model, this.f_103380_, ageInTicks, limbSwing, limbSwingAmount, netHeadYaw, headPitch);
        this.transformer.reset();
        Animation animation = Animation.get(player);
        if (animation == null) {
            return;
        }
        boolean shouldCancel = animation.animatePre(player, this.transformer);
        this.transformer.copyFromBodyToWear();
        if (shouldCancel) {
            this.transformer = null;
            info.cancel();
        }
    }

    @Inject(method={"Lnet/minecraft/client/model/PlayerModel;setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="TAIL")})
    protected void onSetupAnimTail(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo info) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.m_7578_() && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && !ParCoolConfig.Client.Booleans.EnableFPVAnimation.get().booleanValue()) {
            return;
        }
        Animation animation = Animation.get(player);
        if (animation == null) {
            this.transformer = null;
            return;
        }
        if (this.transformer != null) {
            animation.animatePost(player, this.transformer);
            this.transformer.copyFromBodyToWear();
            this.transformer = null;
        }
    }
}

