/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.action.impl.Flipping;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.EasingFunctions;
import com.alrex.parcool.utilities.MathUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.ViewportEvent;

public class FlippingAnimator
extends Animator {
    private final Flipping.Direction direction;

    public FlippingAnimator(Flipping.Direction direction) {
        this.direction = direction;
    }

    private int getMaxAnimationTick() {
        return 12;
    }

    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return !parkourability.get(Flipping.class).isDoing() || this.getTick() >= this.getMaxAnimationTick();
    }

    private float angleFactor(float phase) {
        return EasingFunctions.SinInOutBySquare(phase);
    }

    private float armAngleXFactorFront(float phase) {
        if ((double)phase < 0.1) {
            return 1.0f - 100.0f * (phase - 0.1f) * (phase - 0.1f);
        }
        if ((double)phase < 0.6) {
            return 1.0f - 0.8f * EasingFunctions.CubicInOut((phase - 0.1f) * 2.0f);
        }
        return -0.5f * phase + 0.5f;
    }

    private float armAngleXFactorBack(float phase) {
        if ((double)phase < 0.1) {
            return 1.0f - 100.0f * (phase - 0.1f) * (phase - 0.1f);
        }
        if ((double)phase < 0.6) {
            return 1.0f - EasingFunctions.SinInOutBySquare((phase - 0.1f) * 2.0f);
        }
        return 0.1f * EasingFunctions.SinInOutBySquare((phase - 0.6f) * 2.5f);
    }

    private float legAngleFactorBack(float phase) {
        if ((double)phase < 0.5) {
            return 8.0f * (phase - 0.25f) * (phase - 0.25f);
        }
        return 1.0f - 8.0f * (phase - 0.75f) * (phase - 0.75f);
    }

    private float armAngleZFactor(float phase) {
        if ((double)phase < 0.5) {
            return phase * 0.4f;
        }
        if ((double)phase < 0.75) {
            return 0.2f + 0.8f * EasingFunctions.CubicInOut((phase - 0.5f) * 4.0f);
        }
        return 1.0f - EasingFunctions.CubicInOut((phase - 0.75f) * 4.0f);
    }

    private float legAngleFactorFront(float phase) {
        return 1.0f - 4.0f * (phase - 0.5f) * (phase - 0.5f);
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        float phase = ((float)this.getTick() + transformer.getPartialTick()) / (float)this.getMaxAnimationTick();
        if (this.direction == Flipping.Direction.Front) {
            float armAngleX = -180.0f * this.armAngleXFactorFront(phase) + 25.0f;
            float armAngleZ = MathUtil.lerp((double)phase > 0.75 ? 0.0f : 14.0f, 28.0f, this.armAngleZFactor(phase));
            float legAngleX = MathUtil.lerp(0.0f, -50.0f, this.legAngleFactorFront(phase));
            float headAngle = MathUtil.lerp(0.0f, 45.0f, this.legAngleFactorFront(phase));
            transformer.rotateAdditionallyHeadPitch(headAngle).rotateRightArm((float)Math.toRadians(armAngleX), 0.0f, (float)Math.toRadians(armAngleZ)).rotateLeftArm((float)Math.toRadians(armAngleX), 0.0f, (float)(-Math.toRadians(armAngleZ))).makeArmsNatural().rotateRightLeg((float)Math.toRadians(legAngleX - 15.0f), 0.0f, 0.0f).rotateLeftLeg((float)Math.toRadians(legAngleX + 15.0f), 0.0f, 0.0f).makeLegsLittleMoving().end();
        } else {
            float armAngleX = MathUtil.lerp(20.0f, -190.0f, this.armAngleXFactorBack(phase));
            float armAngleZ = MathUtil.lerp((double)phase > 0.75 ? 0.0f : 14.0f, 28.0f, this.armAngleZFactor(phase));
            float legAngle = MathUtil.lerp(35.0f, -35.0f, this.legAngleFactorBack(phase));
            float headAngle = MathUtil.lerp(0.0f, -45.0f, 1.0f - 4.0f * (phase - 0.5f) * (phase - 0.5f));
            transformer.rotateAdditionallyHeadPitch(headAngle).rotateRightArm((float)Math.toRadians(armAngleX), 0.0f, (float)Math.toRadians(armAngleZ)).rotateLeftArm((float)Math.toRadians(armAngleX), 0.0f, (float)(-Math.toRadians(armAngleZ))).makeArmsNatural().rotateRightLeg((float)Math.toRadians(legAngle - 15.0f), 0.0f, 0.0f).rotateLeftLeg((float)Math.toRadians(legAngle + 15.0f), 0.0f, 0.0f).makeLegsLittleMoving().end();
        }
    }

    @Override
    public void rotate(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        float phase = ((float)this.getTick() + rotator.getPartialTick()) / (float)this.getMaxAnimationTick();
        float factor = this.angleFactor(phase);
        float angle = this.direction == Flipping.Direction.Front ? factor * 360.0f : factor * -360.0f;
        rotator.startBasedCenter().rotatePitchFrontward(angle).end();
    }

    @Override
    public void onCameraSetUp(ViewportEvent.ComputeCameraAngles event, Player clientPlayer, Parkourability parkourability) {
        if (!(clientPlayer.m_7578_() && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && ParCoolConfig.Client.Booleans.EnableCameraAnimationOfFlipping.get().booleanValue())) {
            return;
        }
        float phase = (float)(((double)this.getTick() + event.getPartialTick()) / (double)this.getMaxAnimationTick());
        float factor = this.angleFactor(phase);
        if (this.direction == Flipping.Direction.Front) {
            event.setPitch(clientPlayer.m_5686_((float)event.getPartialTick()) + factor * 360.0f - (float)((double)phase > 0.5 ? 360 : 0));
        } else {
            event.setPitch(clientPlayer.m_5686_((float)event.getPartialTick()) - factor * 360.0f + (float)((double)phase > 0.5 ? 360 : 0));
        }
    }
}

