/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.client.animation.impl.WallSlideAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Dive;
import com.alrex.parcool.common.action.impl.Dodge;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.damage.DamageSources;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WallSlide
extends Action {
    private Vec3 leanedWallDirection = null;
    private byte particleSpawnCoolTime = 0;
    private double startYSpeed = 0.0;
    private int damageCount = 0;
    private int takenDamageCount = 0;
    private byte damageCoolTime = 0;

    @Nullable
    public Vec3 getLeanedWallDirection() {
        return this.leanedWallDirection;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        startInfo.putDouble(Math.abs(player.m_20184_().m_7098_()));
        return this.canContinue(player, parkourability, stamina);
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        Vec3 wall = WorldUtil.getWall((LivingEntity)player);
        return wall != null && !player.m_20096_() && parkourability.getActionInfo().can(WallSlide.class) && !parkourability.get(FastRun.class).isDoing() && !parkourability.get(Dodge.class).isDoing() && !player.m_150110_().f_35935_ && player.m_20184_().f_82480_ <= 0.0 && KeyBindings.getKeyWallSlide().m_90857_() && !stamina.isExhausted() && !parkourability.get(Dive.class).isDoing() && !parkourability.get(ClingToCliff.class).isDoing() && parkourability.get(ClingToCliff.class).getNotDoingTick() > 12;
    }

    @Override
    public void onStart(Player player, Parkourability parkourability) {
        this.particleSpawnCoolTime = 0;
    }

    @Override
    public void onStartInServer(Player player, Parkourability parkourability, ByteBuffer startData) {
        this.startYSpeed = startData.getDouble();
        this.damageCount = (int)(5.5 * (this.startYSpeed - 1.0) / (double)player.m_20206_());
        this.takenDamageCount = 0;
        this.damageCoolTime = 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWorkingTickInClient(Player player, Parkourability parkourability, IStamina stamina) {
        Animation animation = Animation.get(player);
        if (animation != null && !animation.hasAnimator()) {
            animation.setAnimator(new WallSlideAnimator());
        }
        this.particleSpawnCoolTime = (byte)(this.particleSpawnCoolTime - 1);
        if (this.particleSpawnCoolTime <= 0) {
            this.particleSpawnCoolTime = (byte)2;
            this.spawnSlideParticle(player);
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }

    @Override
    public void onWorkingTick(Player player, Parkourability parkourability, IStamina stamina) {
        this.leanedWallDirection = WorldUtil.getWall((LivingEntity)player);
        if (this.leanedWallDirection != null) {
            BlockPos leanedBlock = new BlockPos((int)(player.m_20185_() + this.leanedWallDirection.f_82479_), (int)(player.m_20186_() + (double)player.m_20206_() * 0.75), (int)(player.m_20189_() + this.leanedWallDirection.f_82481_));
            if (!player.f_19853_.m_46749_(leanedBlock)) {
                return;
            }
            float slipperiness = player.f_19853_.m_8055_(leanedBlock).getFriction((LevelReader)player.f_19853_, leanedBlock, (Entity)player);
            slipperiness = (float)Math.sqrt(slipperiness);
            player.f_19789_ *= slipperiness;
            player.m_20256_(player.m_20184_().m_82542_(0.8, (double)slipperiness, 0.8));
        }
    }

    @Override
    public void onWorkingTickInServer(Player player, Parkourability parkourability, IStamina stamina) {
        if (this.damageCoolTime <= 0 && this.damageCount > this.takenDamageCount++) {
            int invulnerableTime = player.f_19802_;
            this.damageCoolTime = 1;
            player.f_19802_ = 0;
            player.m_6469_(player.f_19853_.m_269111_().m_269079_(DamageSources.WALL_SLIDE), 0.3f);
            player.f_19802_ = invulnerableTime;
        } else {
            this.damageCoolTime = (byte)(this.damageCoolTime - 1);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnSlideParticle(Player player) {
        if (this.leanedWallDirection == null) {
            return;
        }
        if (player.m_217043_().m_188499_()) {
            return;
        }
        Level level = player.f_19853_;
        Vec3 pos = player.m_20182_();
        BlockPos leanedBlock = new BlockPos((int)Math.floor(pos.m_7096_() + this.leanedWallDirection.m_7096_()), (int)Math.floor(pos.m_7098_() + (double)player.m_20206_() * 0.25), (int)Math.floor(pos.m_7094_() + this.leanedWallDirection.m_7094_()));
        if (!level.m_46749_(leanedBlock)) {
            return;
        }
        float width = player.m_20205_();
        BlockState blockstate = level.m_8055_(leanedBlock);
        Vec3 normalizedWallVec = this.leanedWallDirection.m_82541_();
        Vec3 orthogonalToWallVec = normalizedWallVec.m_82524_(1.5707964f);
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            Vec3 particlePos = new Vec3(pos.m_7096_() + (normalizedWallVec.m_7096_() * 0.4 + orthogonalToWallVec.m_7096_() * (player.m_217043_().m_188500_() - 0.5)) * (double)width, pos.m_7098_() + (double)player.m_20206_() - 0.2 + 0.3 * player.m_217043_().m_188500_(), pos.m_7094_() + (normalizedWallVec.m_7094_() * 0.4 + orthogonalToWallVec.m_7094_() * (player.m_217043_().m_188500_() - 0.5)) * (double)width);
            Vec3 particleSpeed = normalizedWallVec.m_82548_().m_82524_((float)(0.3141592653589793 * (player.m_217043_().m_188500_() - 0.5))).m_82490_(0.05).m_82520_(0.0, -0.5 - player.m_217043_().m_188500_(), 0.0);
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(leanedBlock), particlePos.m_7096_(), particlePos.m_7098_(), particlePos.m_7094_(), particleSpeed.m_7096_(), particleSpeed.m_7098_(), particleSpeed.m_7094_());
        }
    }
}

