/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.gui;

import com.alrex.parcool.client.gui.ColorTheme;
import com.alrex.parcool.client.gui.ParCoolSettingScreen;
import com.alrex.parcool.common.info.ActionInfo;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class SettingShowLimitationsScreen
extends ParCoolSettingScreen {
    private final InfoSet[] infoList;

    public SettingShowLimitationsScreen(Component titleIn, ActionInfo info, ColorTheme theme) {
        super(titleIn, info, theme);
        this.currentScreen = 3;
        this.infoList = new InfoSet[]{new InfoSet("Max Stamina Limit", Integer.toString(info.getMaxStaminaLimit())), new InfoSet("Infinite Stamina Permission", Boolean.toString(info.isInfiniteStaminaPermitted()))};
    }

    @Override
    protected void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float partialTick, int topOffset, int bottomOffset) {
        int offsetX = 40;
        int contentHeight = this.f_96544_ - topOffset - bottomOffset;
        Objects.requireNonNull(this.f_96547_);
        int itemHeight = 9 * 2;
        int valueWidth = Arrays.stream(this.infoList).map(it -> this.f_96547_.m_92895_(it.value)).max(Integer::compareTo).orElse(0);
        for (int i = 0; i < this.infoList.length; ++i) {
            InfoSet item = this.infoList[i];
            String string = item.name;
            int n = topOffset + itemHeight * i + itemHeight / 2;
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280488_(this.f_96547_, string, 45, n - 9 / 2, this.color.getText());
            String string2 = item.value;
            int n2 = topOffset + itemHeight * i + itemHeight / 2;
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280488_(this.f_96547_, string2, this.f_96543_ - 40 - 5 - valueWidth, n2 - 9 / 2, this.color.getText());
            graphics.m_280509_(40, topOffset + itemHeight * (i + 1), this.f_96543_ - 40, topOffset + itemHeight * (i + 1) + 1, this.color.getSubSeparator());
        }
        graphics.m_280509_(this.f_96543_ - 40, topOffset, this.f_96543_ - 40 - 1, topOffset + contentHeight, this.color.getSeparator());
        graphics.m_280509_(40, topOffset, 41, topOffset + contentHeight, this.color.getSeparator());
    }

    private static class InfoSet {
        final String name;
        final String value;

        InfoSet(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

