/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.extern.feathers;

import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.stamina.Stamina;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.extern.feathers.FeathersStamina;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;

public class FeathersManager {
    private static boolean feathersInstalled = false;

    public static boolean isFeathersInstalled() {
        return feathersInstalled;
    }

    public static void init() {
        IModFileInfo mod = ModList.get().getModFileById("feathers");
        feathersInstalled = mod != null;
    }

    public static IStamina newFeathersStaminaFor(Player player) {
        if (!feathersInstalled) {
            return new Stamina(player);
        }
        return new FeathersStamina(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isUsingFeathers() {
        return feathersInstalled && ParCoolConfig.Client.StaminaType.get() == IStamina.Type.Feathers;
    }
}

