/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.ClingToCliffAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ClimbUp;
import com.alrex.parcool.common.action.impl.HorizontalWallRun;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.VectorUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;

public class ClingToCliff
extends Action {
    private float armSwingAmount = 0.0f;
    private FacingDirection facingDirection = FacingDirection.ToWall;
    @Nullable
    private Vec3 clingWallDirection = null;

    public float getArmSwingAmount() {
        return this.armSwingAmount;
    }

    @Override
    public void onWorkingTick(Player player, Parkourability parkourability, IStamina stamina) {
        player.f_19789_ = 0.0f;
    }

    public FacingDirection getFacingDirection() {
        return this.facingDirection;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        boolean value;
        boolean bl = value = !stamina.isExhausted() && player.m_20184_().m_7098_() < 0.2 && !player.m_6144_() && !parkourability.get(HorizontalWallRun.class).isDoing() && KeyBindings.getKeyGrabWall().m_90857_();
        if (!value) {
            return false;
        }
        Vec3 wallVec = WorldUtil.getGrabbableWall((LivingEntity)player);
        if (wallVec == null) {
            return false;
        }
        startInfo.putDouble(wallVec.m_7096_()).putDouble(wallVec.m_7094_());
        return 0.5 < wallVec.m_82541_().m_82526_(player.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return !stamina.isExhausted() && !player.m_6144_() && parkourability.getActionInfo().can(ClingToCliff.class) && KeyBindings.getKeyGrabWall().m_90857_() && !parkourability.get(HorizontalWallRun.class).isDoing() && !parkourability.get(ClimbUp.class).isDoing() && WorldUtil.getGrabbableWall((LivingEntity)player) != null;
    }

    @Override
    public void onStart(Player player, Parkourability parkourability) {
        this.armSwingAmount = 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        Animation animation;
        this.clingWallDirection = new Vec3(startData.getDouble(), 0.0, startData.getDouble());
        this.facingDirection = FacingDirection.ToWall;
        this.armSwingAmount = 0.0f;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.CLING_TO_CLIFF.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new ClingToCliffAnimator());
        }
    }

    @Override
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        Animation animation;
        this.clingWallDirection = new Vec3(startData.getDouble(), 0.0, startData.getDouble());
        this.facingDirection = FacingDirection.ToWall;
        this.armSwingAmount = 0.0f;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.CLING_TO_CLIFF.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null) {
            animation.setAnimator(new ClingToCliffAnimator());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWorkingTickInLocalClient(Player player, Parkourability parkourability, IStamina stamina) {
        this.armSwingAmount += (float)player.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82556_();
        if (KeyBindings.getKeyLeft().m_90857_() && KeyBindings.getKeyRight().m_90857_()) {
            player.m_20334_(0.0, 0.0, 0.0);
        } else if (this.clingWallDirection != null && this.facingDirection == FacingDirection.ToWall) {
            Vec3 vec = this.clingWallDirection.m_82524_(1.5707964f).m_82541_().m_82490_(0.1);
            if (KeyBindings.getKeyLeft().m_90857_()) {
                player.m_20256_(vec);
            } else if (KeyBindings.getKeyRight().m_90857_()) {
                player.m_20256_(vec.m_82548_());
            } else {
                player.m_20334_(0.0, 0.0, 0.0);
            }
        } else {
            player.m_20334_(0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onWorkingTickInClient(Player player, Parkourability parkourability, IStamina stamina) {
        this.clingWallDirection = WorldUtil.getGrabbableWall((LivingEntity)player);
        if (this.clingWallDirection == null) {
            return;
        }
        this.clingWallDirection = this.clingWallDirection.m_82541_();
        Vec3 lookingAngle = player.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_();
        Vec3 angle = new Vec3(this.clingWallDirection.m_7096_() * lookingAngle.m_7096_() + this.clingWallDirection.m_7094_() * lookingAngle.m_7094_(), 0.0, -this.clingWallDirection.m_7096_() * lookingAngle.m_7094_() + this.clingWallDirection.m_7094_() * lookingAngle.m_7096_()).m_82541_();
        this.facingDirection = angle.m_7096_() > 0.342 ? FacingDirection.ToWall : (angle.m_7094_() < 0.0 ? FacingDirection.RightAgainstWall : FacingDirection.LeftAgainstWall);
    }

    @Override
    public void saveSynchronizedState(ByteBuffer buffer) {
        buffer.putFloat(this.armSwingAmount);
    }

    @Override
    public void restoreSynchronizedState(ByteBuffer buffer) {
        this.armSwingAmount = buffer.getFloat();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event, Player player, Parkourability parkourability) {
        if (this.isDoing() && this.clingWallDirection != null) {
            switch (this.facingDirection) {
                case ToWall: {
                    player.m_5618_((float)VectorUtil.toYawDegree(this.clingWallDirection));
                    break;
                }
                case RightAgainstWall: {
                    player.f_20884_ = player.f_20883_ = (float)VectorUtil.toYawDegree(this.clingWallDirection.m_82524_(-1.5707964f));
                    break;
                }
                case LeftAgainstWall: {
                    player.f_20884_ = player.f_20883_ = (float)VectorUtil.toYawDegree(this.clingWallDirection.m_82524_(1.5707964f));
                }
            }
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnWorking;
    }

    public static enum FacingDirection {
        ToWall,
        RightAgainstWall,
        LeftAgainstWall;

    }
}

