/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.KongVaultAnimator;
import com.alrex.parcool.client.animation.impl.SpeedVaultAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.FastRun;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.registries.ParCoolPoses;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.BufferUtil;
import com.alrex.parcool.utilities.WorldUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Vault
extends Action {
    public static final int MAX_TICK = 11;
    private double stepHeight = 0.0;
    private Vec3 stepDirection = null;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        Vec3 lookVec = player.m_20154_();
        lookVec = new Vec3(lookVec.m_7096_(), 0.0, lookVec.m_7094_()).m_82541_();
        Vec3 step = WorldUtil.getVaultableStep((LivingEntity)player);
        if (step == null) {
            return false;
        }
        step = step.m_82541_();
        Vec3 dividedVec = new Vec3(lookVec.m_7096_() * step.m_7096_() + lookVec.m_7094_() * step.m_7094_(), 0.0, -lookVec.m_7096_() * step.m_7094_() + lookVec.m_7094_() * step.m_7096_()).m_82541_();
        if (dividedVec.m_7096_() < 0.707106) {
            return false;
        }
        AnimationType animationType = null;
        SpeedVaultAnimator.Type type = SpeedVaultAnimator.Type.Right;
        switch ((TypeSelectionMode)((Object)ParCoolConfig.Client.VaultAnimationMode.get())) {
            case KongVault: {
                animationType = AnimationType.KongVault;
                break;
            }
            case SpeedVault: {
                animationType = AnimationType.SpeedVault;
                type = dividedVec.m_7094_() > 0.0 ? SpeedVaultAnimator.Type.Right : SpeedVaultAnimator.Type.Left;
                break;
            }
            default: {
                if (dividedVec.m_7096_() > 0.99) {
                    animationType = AnimationType.KongVault;
                    break;
                }
                animationType = AnimationType.SpeedVault;
                type = dividedVec.m_7094_() > 0.0 ? SpeedVaultAnimator.Type.Right : SpeedVaultAnimator.Type.Left;
            }
        }
        double wallHeight = WorldUtil.getWallHeight((LivingEntity)player);
        startInfo.put(animationType.getCode());
        BufferUtil.wrap(startInfo).putBoolean(type == SpeedVaultAnimator.Type.Right);
        startInfo.putDouble(step.m_7096_()).putDouble(step.m_7098_()).putDouble(step.m_7094_()).putDouble(wallHeight);
        return !(stamina.isExhausted() || ParCoolConfig.Client.Booleans.VaultKeyPressedNeeded.get() != false && !KeyBindings.getKeyVault().m_90857_() || !parkourability.get(FastRun.class).canActWithRunning(player) || stamina.isExhausted() || !player.m_20096_() && ParCoolConfig.Client.Booleans.EnableVaultInAir.get() == false || !(wallHeight > (double)player.m_20206_() * 0.44));
    }

    @Override
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return this.getDoingTick() < 11;
    }

    private int getVaultAnimateTime() {
        return 2;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        SpeedVaultAnimator.Type speedVaultType;
        AnimationType animationType = AnimationType.fromCode(startData.get());
        SpeedVaultAnimator.Type type = speedVaultType = BufferUtil.getBoolean(startData) ? SpeedVaultAnimator.Type.Right : SpeedVaultAnimator.Type.Left;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.VAULT.get(), 1.0f, 1.0f);
        }
        this.stepDirection = new Vec3(startData.getDouble(), startData.getDouble(), startData.getDouble());
        this.stepHeight = startData.getDouble();
        Animation animation = Animation.get(player);
        if (animation != null && animationType != null) {
            switch (animationType) {
                case SpeedVault: {
                    animation.setAnimator(new SpeedVaultAnimator(speedVaultType));
                    break;
                }
                case KongVault: {
                    animation.setAnimator(new KongVaultAnimator());
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        Animation animation;
        SpeedVaultAnimator.Type speedVaultType;
        AnimationType animationType = AnimationType.fromCode(startData.get());
        SpeedVaultAnimator.Type type = speedVaultType = BufferUtil.getBoolean(startData) ? SpeedVaultAnimator.Type.Right : SpeedVaultAnimator.Type.Left;
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.VAULT.get(), 1.0f, 1.0f);
        }
        if ((animation = Animation.get(player)) != null && animationType != null) {
            switch (animationType) {
                case SpeedVault: {
                    animation.setAnimator(new SpeedVaultAnimator(speedVaultType));
                    break;
                }
                case KongVault: {
                    animation.setAnimator(new KongVaultAnimator());
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWorkingTickInLocalClient(Player player, Parkourability parkourability, IStamina stamina) {
        if (this.stepDirection == null) {
            return;
        }
        if (this.getDoingTick() < this.getVaultAnimateTime()) {
            player.m_20334_(this.stepDirection.m_7096_() / 10.0, (this.stepHeight + 0.02) / (double)this.getVaultAnimateTime() / ((double)player.m_20206_() / 1.8), this.stepDirection.m_7094_() / 10.0);
        } else if (this.getDoingTick() == this.getVaultAnimateTime()) {
            this.stepDirection = this.stepDirection.m_82541_();
            player.m_20334_(this.stepDirection.m_7096_() * 0.45, 0.075 * ((double)player.m_20206_() / 1.8), this.stepDirection.m_7094_() * 0.45);
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStopInLocalClient(Player player) {
    }

    @Override
    public void onWorkingTick(Player player, Parkourability parkourability, IStamina stamina) {
        Pose pose = ParCoolPoses.VAULTING.get();
        player.m_20124_(pose);
    }

    public static enum TypeSelectionMode {
        SpeedVault,
        KongVault,
        Dynamic;

    }

    public static enum AnimationType {
        SpeedVault(0),
        KongVault(1);

        private final byte code;

        private AnimationType(byte code) {
            this.code = code;
        }

        public byte getCode() {
            return this.code;
        }

        @Nullable
        public static AnimationType fromCode(byte code) {
            switch (code) {
                case 0: {
                    return SpeedVault;
                }
                case 1: {
                    return KongVault;
                }
            }
            return null;
        }
    }
}

