/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.action.impl.FastSwim;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.utilities.MathUtil;
import com.alrex.parcool.utilities.VectorUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class FastSwimAnimator
extends Animator {
    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return !parkourability.get(FastSwim.class).isDoing();
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        float tick;
        double armFactor;
        double leftArmXAngle;
        double rightArmXAngle;
        float animationFactor = ((float)this.getTick() + transformer.getPartialTick()) / 10.0f;
        if (animationFactor > 1.0f) {
            animationFactor = 1.0f;
        }
        if ((rightArmXAngle = -(leftArmXAngle = 45.0 * (armFactor = Math.cos(Math.PI * (double)(tick = (float)this.getTick() + transformer.getPartialTick()) / 15.0)))) < 0.0) {
            rightArmXAngle = -3.0 * Math.sqrt(-rightArmXAngle);
        }
        if (leftArmXAngle < 0.0) {
            leftArmXAngle = -3.0 * Math.sqrt(-leftArmXAngle);
        }
        transformer.getRawModel().f_102811_.f_104200_ = (float)((double)transformer.getRawModel().f_102811_.f_104200_ + Math.max(0.0, 2.4 * Math.sin(Math.PI * (double)tick / 15.0)));
        transformer.getRawModel().f_102811_.f_104201_ = (float)((double)transformer.getRawModel().f_102811_.f_104201_ + Math.max(0.0, 1.2 * Math.sin(Math.PI * (double)tick / 15.0)));
        transformer.getRawModel().f_102811_.f_104202_ = (float)((double)transformer.getRawModel().f_102811_.f_104202_ - 1.2 * Math.sin(Math.PI * (double)tick / 15.0));
        transformer.getRawModel().f_102812_.f_104200_ = (float)((double)transformer.getRawModel().f_102812_.f_104200_ - Math.max(0.0, -2.4 * Math.sin(Math.PI * (double)tick / 15.0)));
        transformer.getRawModel().f_102812_.f_104201_ = (float)((double)transformer.getRawModel().f_102812_.f_104201_ + Math.max(0.0, -1.2 * Math.sin(Math.PI * (double)tick / 15.0)));
        transformer.getRawModel().f_102811_.f_104202_ = (float)((double)transformer.getRawModel().f_102811_.f_104202_ + 1.2 * Math.sin(Math.PI * (double)tick / 15.0));
        transformer.getRawModel().f_102808_.f_104202_ += 0.5f * animationFactor;
        transformer.rotateAdditionallyHeadYaw((float)(-5.0 * Math.sin(Math.PI * (double)tick / 15.0))).rotateRightArm((float)Math.toRadians(-190.0 + rightArmXAngle), 0.0f, (float)Math.toRadians(-40.0 + 50.0 * Math.sin(Math.PI * (double)tick / 15.0))).rotateLeftArm((float)Math.toRadians(-190.0 + leftArmXAngle), 0.0f, (float)Math.toRadians(40.0 + 50.0 * Math.sin(Math.PI * (double)tick / 15.0))).rotateRightLeg((float)Math.toRadians(-40.0 * Math.cos(Math.PI * (double)tick / 9.0)), 0.0f, 0.0f, animationFactor).rotateLeftLeg((float)Math.toRadians(40.0 * Math.cos(Math.PI * (double)tick / 9.0)), 0.0f, 0.0f, animationFactor).end();
    }

    @Override
    public void rotate(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        float tick = (float)this.getTick() + rotator.getPartialTick();
        Vec3 lookAngle = player.m_20154_();
        Vec3 bodyAngle = VectorUtil.fromYawDegree(MathUtil.lerp(player.f_20884_, player.f_20883_, rotator.getPartialTick()));
        Vec3 differenceVec = new Vec3(lookAngle.m_7096_() * bodyAngle.m_7096_() + lookAngle.m_7094_() * bodyAngle.m_7094_(), 0.0, -lookAngle.m_7096_() * bodyAngle.m_7094_() + lookAngle.m_7094_() * bodyAngle.m_7096_()).m_82541_();
        rotator.startBasedCenter().rotateRollRightward((float)(-15.0 * Math.asin(differenceVec.m_7094_()) + 12.0 * Math.sin(Math.PI * (double)tick / 15.0))).end();
    }
}

