/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation.impl;

import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.Easing;
import com.alrex.parcool.utilities.EasingFunctions;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.ViewportEvent;

public class KongVaultAnimator
extends Animator {
    float getFactor(float phase) {
        if ((double)phase < 0.5) {
            return EasingFunctions.SinInOutBySquare(phase * 2.0f);
        }
        return EasingFunctions.SinInOutBySquare(2.0f - phase * 2.0f);
    }

    float getArmFactor(float phase) {
        return (double)phase < 0.2 ? 1.0f - 25.0f * (phase - 0.2f) * (phase - 0.2f) : 1.0f - EasingFunctions.SinInOutBySquare((phase - 0.2f) * 1.25f);
    }

    @Override
    public boolean shouldRemoved(Player player, Parkourability parkourability) {
        return this.getTick() >= 11;
    }

    @Override
    public void animatePost(Player player, Parkourability parkourability, PlayerModelTransformer transformer) {
        float phase = ((float)this.getTick() + transformer.getPartialTick()) / 11.0f;
        float armFactor = this.getArmFactor(phase);
        float factor = this.getFactor(phase);
        float animFactor = new Easing(phase).sinInOut(0.0f, 0.25f, 0.0f, 1.0f).linear(0.25f, 0.75f, 1.0f, 1.0f).sinInOut(0.75f, 1.0f, 1.0f, 0.0f).get();
        transformer.rotateAdditionallyHeadPitch(-40.0f * armFactor).rotateRightArm((float)Math.toRadians(30.0f - 195.0f * armFactor), 0.0f, (float)Math.toRadians(30.0f - 30.0f * armFactor), animFactor).rotateLeftArm((float)Math.toRadians(25.0f - 195.0f * armFactor), 0.0f, (float)Math.toRadians(-30.0f + 30.0f * armFactor), animFactor).rotateRightLeg((float)Math.toRadians(-20.0f + 55.0f * factor), 0.0f, 0.0f, animFactor).rotateLeftLeg((float)Math.toRadians(-10.0f + 20.0f * factor), 0.0f, 0.0f, animFactor).makeLegsLittleMoving().end();
    }

    @Override
    public void rotate(Player player, Parkourability parkourability, PlayerModelRotator rotator) {
        float phase = ((float)this.getTick() + rotator.getPartialTick()) / 11.0f;
        float factor = this.getFactor(phase);
        float yFactor = new Easing(phase).squareOut(0.0f, 0.5f, 0.0f, 1.0f).squareIn(0.5f, 1.0f, 1.0f, 0.0f).get();
        rotator.startBasedCenter().translateY(-yFactor * player.m_20206_() / 5.0f).rotatePitchFrontward(factor * 95.0f).end();
    }

    @Override
    public void onCameraSetUp(ViewportEvent.ComputeCameraAngles event, Player clientPlayer, Parkourability parkourability) {
        if (!Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() || !ParCoolConfig.Client.Booleans.EnableCameraAnimationOfVault.get().booleanValue()) {
            return;
        }
        float phase = (float)(((double)this.getTick() + event.getPartialTick()) / 11.0);
        float factor = this.getFactor(phase);
        event.setPitch(30.0f * factor + clientPlayer.m_5686_((float)event.getPartialTick()));
    }
}

