/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.action.impl;

import com.alrex.parcool.api.SoundEvents;
import com.alrex.parcool.client.animation.impl.DodgeAnimator;
import com.alrex.parcool.client.input.KeyBindings;
import com.alrex.parcool.client.input.KeyRecorder;
import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.action.StaminaConsumeTiming;
import com.alrex.parcool.common.action.impl.ClingToCliff;
import com.alrex.parcool.common.action.impl.Roll;
import com.alrex.parcool.common.capability.Animation;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.ActionInfo;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.utilities.VectorUtil;
import java.nio.ByteBuffer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Dodge
extends Action {
    public static final int MAX_TICK = 11;
    private DodgeDirection dodgeDirection = null;
    private int coolTime = 0;
    private int successivelyCount = 0;
    private int successivelyCoolTick = 0;

    private static int getMaxCoolTime(ActionInfo info) {
        int value = info.getClientInformation().get(ParCoolConfig.Client.Integers.DodgeCoolTime);
        if (info.getIndividualLimitation().isEnabled()) {
            value = Math.max(value, info.getIndividualLimitation().get(ParCoolConfig.Server.Integers.DodgeCoolTime));
        }
        if (info.getServerLimitation().isEnabled()) {
            value = Math.max(value, info.getServerLimitation().get(ParCoolConfig.Server.Integers.DodgeCoolTime));
        }
        return value;
    }

    private static int getMaxSuccessiveDodge(ActionInfo info) {
        int value = info.getClientInformation().get(ParCoolConfig.Client.Integers.MaxSuccessiveDodgeCount);
        if (info.getIndividualLimitation().isEnabled()) {
            value = Math.min(value, info.getIndividualLimitation().get(ParCoolConfig.Server.Integers.MaxSuccessiveDodgeCount));
        }
        if (info.getServerLimitation().isEnabled()) {
            value = Math.min(value, info.getServerLimitation().get(ParCoolConfig.Server.Integers.MaxSuccessiveDodgeCount));
        }
        return value;
    }

    private static int getSuccessiveCoolTime(ActionInfo info) {
        int value = info.getClientInformation().get(ParCoolConfig.Client.Integers.SuccessiveDodgeCoolTime);
        if (info.getIndividualLimitation().isEnabled()) {
            value = Math.max(value, info.getIndividualLimitation().get(ParCoolConfig.Server.Integers.SuccessiveDodgeCoolTime));
        }
        if (info.getServerLimitation().isEnabled()) {
            value = Math.max(value, info.getServerLimitation().get(ParCoolConfig.Server.Integers.SuccessiveDodgeCoolTime));
        }
        return value;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(Player player, Parkourability parkourability, IStamina stamina) {
        if (this.coolTime > 0) {
            --this.coolTime;
        }
        if (this.successivelyCoolTick > 0) {
            --this.successivelyCoolTick;
        } else {
            this.successivelyCount = 0;
        }
    }

    @Override
    public StaminaConsumeTiming getStaminaConsumeTiming() {
        return StaminaConsumeTiming.OnStart;
    }

    public double getSpeedModifier(ActionInfo info) {
        double value = info.getClientInformation().get(ParCoolConfig.Client.Doubles.DodgeSpeedModifier);
        if (info.getServerLimitation().isEnabled()) {
            value = Math.min(value, info.getServerLimitation().get(ParCoolConfig.Server.Doubles.MaxDodgeSpeedModifier));
        }
        if (info.getIndividualLimitation().isEnabled()) {
            value = Math.min(value, info.getIndividualLimitation().get(ParCoolConfig.Server.Doubles.MaxDodgeSpeedModifier));
        }
        return value;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canStart(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startInfo) {
        boolean enabledDoubleTap = ParCoolConfig.Client.Booleans.EnableDoubleTappingForDodge.get();
        DodgeDirection direction = null;
        if (enabledDoubleTap) {
            if (KeyRecorder.keyBack.isDoubleTapped()) {
                direction = DodgeDirection.Back;
            }
            if (KeyRecorder.keyLeft.isDoubleTapped()) {
                direction = DodgeDirection.Left;
            }
            if (KeyRecorder.keyRight.isDoubleTapped()) {
                direction = DodgeDirection.Right;
            }
        }
        if (direction == null && KeyRecorder.keyDodge.isPressed()) {
            if (KeyBindings.getKeyBack().m_90857_()) {
                direction = DodgeDirection.Back;
            }
            if (KeyBindings.getKeyForward().m_90857_()) {
                direction = DodgeDirection.Front;
            }
            if (KeyBindings.getKeyLeft().m_90857_()) {
                direction = DodgeDirection.Left;
            }
            if (KeyBindings.getKeyRight().m_90857_()) {
                direction = DodgeDirection.Right;
            }
        }
        if (direction == null) {
            return false;
        }
        startInfo.putInt(direction.ordinal());
        return parkourability.getAdditionalProperties().getLandingTick() > 5 && !this.isInSuccessiveCoolDown(parkourability.getActionInfo()) && this.coolTime <= 0 && player.m_20096_() && !player.m_20072_() && !player.m_6144_() && !stamina.isExhausted();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean canContinue(Player player, Parkourability parkourability, IStamina stamina) {
        return !parkourability.get(Roll.class).isDoing() && !parkourability.get(ClingToCliff.class).isDoing() && this.getDoingTick() < 11 && !player.m_20072_() && !player.m_21255_() && !player.m_150110_().f_35935_;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInLocalClient(Player player, Parkourability parkourability, IStamina stamina, ByteBuffer startData) {
        this.dodgeDirection = DodgeDirection.values()[startData.getInt()];
        this.coolTime = Dodge.getMaxCoolTime(parkourability.getActionInfo());
        if (this.successivelyCount < Dodge.getMaxSuccessiveDodge(parkourability.getActionInfo())) {
            ++this.successivelyCount;
        }
        if (ParCoolConfig.Client.Booleans.EnableActionSounds.get().booleanValue()) {
            player.m_5496_((SoundEvent)SoundEvents.DODGE.get(), 1.0f, 1.0f);
        }
        this.successivelyCoolTick = Dodge.getSuccessiveCoolTime(parkourability.getActionInfo());
        if (!player.m_20096_()) {
            return;
        }
        Vec3 lookVec = VectorUtil.fromYawDegree(player.m_6080_());
        Vec3 dodgeVec = Vec3.f_82478_;
        switch (this.dodgeDirection) {
            case Front: {
                dodgeVec = lookVec;
                break;
            }
            case Back: {
                dodgeVec = lookVec.m_82548_();
                break;
            }
            case Right: {
                dodgeVec = lookVec.m_82524_(-1.5707964f);
                break;
            }
            case Left: {
                dodgeVec = lookVec.m_82524_(1.5707964f);
            }
        }
        dodgeVec = dodgeVec.m_82490_(0.9 * this.getSpeedModifier(parkourability.getActionInfo()));
        player.m_20256_(dodgeVec);
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new DodgeAnimator(this.dodgeDirection));
        }
        parkourability.getCancelMarks().addMarkerCancellingJump(this::isDoing);
        if (!parkourability.getClientInfo().get(ParCoolConfig.Client.Booleans.CanGetOffStepsWhileDodge).booleanValue()) {
            parkourability.getCancelMarks().addMarkerCancellingDescendFromEdge(this::isDoing);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onStartInOtherClient(Player player, Parkourability parkourability, ByteBuffer startData) {
        this.dodgeDirection = DodgeDirection.values()[startData.getInt()];
        Animation animation = Animation.get(player);
        if (animation != null) {
            animation.setAnimator(new DodgeAnimator(this.dodgeDirection));
        }
    }

    public int getCoolTime() {
        return this.coolTime;
    }

    public int getSuccessivelyCoolTick() {
        return this.successivelyCoolTick;
    }

    public boolean isInSuccessiveCoolDown(ActionInfo info) {
        return this.successivelyCount >= Dodge.getMaxSuccessiveDodge(info);
    }

    public float getCoolDownPhase(ActionInfo info) {
        int maxCoolTime = Dodge.getMaxCoolTime(info);
        int successiveMaxCoolTime = Dodge.getSuccessiveCoolTime(info);
        return Math.min((float)(maxCoolTime - this.getCoolTime()) / (float)maxCoolTime, this.isInSuccessiveCoolDown(info) ? (float)(successiveMaxCoolTime - this.getSuccessivelyCoolTick()) / (float)successiveMaxCoolTime : 1.0f);
    }

    public static enum DodgeDirection {
        Front,
        Back,
        Left,
        Right;

    }
}

