/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.network;

import com.alrex.parcool.ParCool;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.Limitations;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncLimitationMessage {
    private final ByteBuffer data = ByteBuffer.allocate(512);
    private boolean forIndividuals = false;

    public void encode(FriendlyByteBuf packet) {
        packet.writeBoolean(this.forIndividuals);
        packet.writeBytes(this.data);
        this.data.rewind();
    }

    public static SyncLimitationMessage decode(FriendlyByteBuf packet) {
        SyncLimitationMessage message = new SyncLimitationMessage();
        message.forIndividuals = packet.readBoolean();
        while (packet.isReadable()) {
            message.data.put(packet.readByte());
        }
        message.data.flip();
        return message;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handle(CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            Parkourability parkourability = Parkourability.get((Player)player);
            if (parkourability == null) {
                return;
            }
            if (this.forIndividuals) {
                parkourability.getActionInfo().getIndividualLimitation().readFrom(this.data);
                this.data.rewind();
            } else {
                parkourability.getActionInfo().getServerLimitation().readFrom(this.data);
                this.data.rewind();
            }
        });
        context.setPacketHandled(true);
    }

    private static SyncLimitationMessage newInstance(Limitations limitation) {
        SyncLimitationMessage message = new SyncLimitationMessage();
        limitation.writeTo(message.data);
        message.data.flip();
        return message;
    }

    public static void sendServerLimitation(ServerPlayer player) {
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        parkourability.getActionInfo().getServerLimitation().readFromServerConfig();
        parkourability.getActionInfo().getServerLimitation().setReceived();
        SyncLimitationMessage msg = SyncLimitationMessage.newInstance(parkourability.getActionInfo().getServerLimitation());
        msg.forIndividuals = false;
        ParCool.CHANNEL_INSTANCE.send((Object)msg, PacketDistributor.PLAYER.with((Object)player));
    }

    public static void sendIndividualLimitation(ServerPlayer player) {
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        parkourability.getActionInfo().getIndividualLimitation().setReceived();
        SyncLimitationMessage msg = SyncLimitationMessage.newInstance(parkourability.getActionInfo().getIndividualLimitation());
        msg.forIndividuals = true;
        ParCool.CHANNEL_INSTANCE.send((Object)msg, PacketDistributor.PLAYER.with((Object)player));
    }
}

