/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.server.command.impl;

import com.alrex.parcool.common.action.Action;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.common.info.Limitations;
import com.alrex.parcool.config.ParCoolConfig;
import com.alrex.parcool.server.command.args.ActionArgumentType;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.command.EnumArgument;

public class ChangeIndividualLimitationCommand {
    private static final String ARGS_NAME_PLAYERS = "targets";
    private static final String ARGS_NAME_PLAYER = "target";
    private static final String ARGS_NAME_ACTION = "action";
    private static final String ARGS_NAME_STAMINA_CONSUMPTION = "stamina_consumption";
    private static final String ARGS_NAME_POSSIBILITY = "possibility";
    private static final String ARGS_NAME_VALUE = "value";
    private static final String ARGS_NAME_CONFIG_ITEM = "limitation_name";

    public static ArgumentBuilder<CommandSourceStack, ?> getBuilder() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"limitation").requires(commandSource -> commandSource.m_6761_(2))).then(Commands.m_82127_((String)"enable").then(Commands.m_82129_((String)ARGS_NAME_PLAYERS, (ArgumentType)EntityArgument.m_91470_()).executes(ChangeIndividualLimitationCommand::enableLimitation)))).then(Commands.m_82127_((String)"disable").then(Commands.m_82129_((String)ARGS_NAME_PLAYERS, (ArgumentType)EntityArgument.m_91470_()).executes(ChangeIndividualLimitationCommand::disableLimitation)))).then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)ARGS_NAME_PLAYERS, (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"to_default").executes(ChangeIndividualLimitationCommand::setLimitationDefault))).then(Commands.m_82127_((String)"boolean").then(Commands.m_82129_((String)ARGS_NAME_CONFIG_ITEM, (ArgumentType)EnumArgument.enumArgument(ParCoolConfig.Server.Booleans.class)).then(Commands.m_82129_((String)ARGS_NAME_VALUE, (ArgumentType)BoolArgumentType.bool()).executes(ChangeIndividualLimitationCommand::setBoolLimitation))))).then(Commands.m_82127_((String)"integer").then(Commands.m_82129_((String)ARGS_NAME_CONFIG_ITEM, (ArgumentType)EnumArgument.enumArgument(ParCoolConfig.Server.Integers.class)).then(Commands.m_82129_((String)ARGS_NAME_VALUE, (ArgumentType)IntegerArgumentType.integer()).executes(ChangeIndividualLimitationCommand::setIntLimitation))))).then(Commands.m_82127_((String)"reals").then(Commands.m_82129_((String)ARGS_NAME_CONFIG_ITEM, (ArgumentType)EnumArgument.enumArgument(ParCoolConfig.Server.Doubles.class)).then(Commands.m_82129_((String)ARGS_NAME_VALUE, (ArgumentType)DoubleArgumentType.doubleArg()).executes(ChangeIndividualLimitationCommand::setDoubleLimitation))))).then(Commands.m_82127_((String)ARGS_NAME_POSSIBILITY).then(Commands.m_82129_((String)ARGS_NAME_ACTION, (ArgumentType)ActionArgumentType.action()).then(Commands.m_82129_((String)ARGS_NAME_POSSIBILITY, (ArgumentType)BoolArgumentType.bool()).executes(ChangeIndividualLimitationCommand::changePossibilityOfAction))))).then(Commands.m_82127_((String)"least_stamina_consumption").then(Commands.m_82129_((String)ARGS_NAME_ACTION, (ArgumentType)ActionArgumentType.action()).then(Commands.m_82129_((String)ARGS_NAME_STAMINA_CONSUMPTION, (ArgumentType)IntegerArgumentType.integer((int)0, (int)Integer.MAX_VALUE)).executes(ChangeIndividualLimitationCommand::changeStaminaConsumption))))))).then(Commands.m_82127_((String)"get").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)ARGS_NAME_PLAYER, (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82127_((String)"max_stamina").executes(it -> ChangeIndividualLimitationCommand.getLimitationValue((CommandContext<CommandSourceStack>)it, 0)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)ARGS_NAME_POSSIBILITY).then(Commands.m_82127_((String)"infinite_stamina").executes(it -> ChangeIndividualLimitationCommand.getLimitationValue((CommandContext<CommandSourceStack>)it, 1)))).then(Commands.m_82129_((String)ARGS_NAME_ACTION, (ArgumentType)ActionArgumentType.action()).executes(it -> ChangeIndividualLimitationCommand.getLimitationValue((CommandContext<CommandSourceStack>)it, 2))))).then(Commands.m_82127_((String)"least_stamina_consumption").then(Commands.m_82129_((String)ARGS_NAME_ACTION, (ArgumentType)ActionArgumentType.action()).executes(it -> ChangeIndividualLimitationCommand.getLimitationValue((CommandContext<CommandSourceStack>)it, 3))))));
    }

    private static int getLimitationValue(CommandContext<CommandSourceStack> context, int code) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(context, (String)ARGS_NAME_PLAYER);
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a74[Internal Error] Parkourability is null"), true);
            return 1;
        }
        switch (code) {
            case 0: {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)Integer.toString(parkourability.getActionInfo().getIndividualLimitation().get(ParCoolConfig.Server.Integers.MaxStaminaLimit))), false);
                break;
            }
            case 1: {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)Boolean.toString(parkourability.getActionInfo().getIndividualLimitation().isInfiniteStaminaPermitted())), false);
                break;
            }
            case 2: {
                Class<? extends Action> action = ActionArgumentType.getAction(context, ARGS_NAME_ACTION);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)Boolean.toString(parkourability.getActionInfo().getIndividualLimitation().isPermitted(action))), false);
                break;
            }
            case 3: {
                Class<? extends Action> action = ActionArgumentType.getAction(context, ARGS_NAME_ACTION);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)Integer.toString(parkourability.getActionInfo().getIndividualLimitation().getLeastStaminaConsumption(action))), false);
                break;
            }
            default: {
                return 1;
            }
        }
        return 0;
    }

    private static int setLimitationDefault(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS);
        int num = 0;
        for (ServerPlayer player : targets) {
            Limitations.Changer.get(player).setAllDefault().sync();
            ++num;
        }
        int finalNum = num;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"parcool.command.message.success.setLimitationToDefault", (Object[])new Object[]{finalNum}), true);
        return 0;
    }

    private static int setBoolLimitation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS);
        ParCoolConfig.Server.Booleans item = (ParCoolConfig.Server.Booleans)context.getArgument(ARGS_NAME_CONFIG_ITEM, ParCoolConfig.Server.Booleans.class);
        boolean value = BoolArgumentType.getBool(context, (String)ARGS_NAME_VALUE);
        int num = 0;
        for (ServerPlayer player : targets) {
            Limitations.Changer.get(player).set(item, value).sync();
            ++num;
        }
        int finalNum = num;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"parcool.command.message.success.set", (Object[])new Object[]{finalNum, item.getPath(), Boolean.toString(value)}), true);
        return 0;
    }

    private static int setIntLimitation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS);
        ParCoolConfig.Server.Integers item = (ParCoolConfig.Server.Integers)context.getArgument(ARGS_NAME_CONFIG_ITEM, ParCoolConfig.Server.Integers.class);
        int value = IntegerArgumentType.getInteger(context, (String)ARGS_NAME_VALUE);
        if (value < item.Min) {
            value = item.Min;
        }
        if (value > item.Max) {
            value = item.Max;
        }
        int num = 0;
        for (ServerPlayer player : targets) {
            Limitations.Changer.get(player).set(item, value).sync();
            ++num;
        }
        int finalNum = num;
        int finalValue = value;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"parcool.command.message.success.set", (Object[])new Object[]{finalNum, item.getPath(), Integer.toString(finalValue)}), true);
        return 0;
    }

    private static int setDoubleLimitation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS);
        ParCoolConfig.Server.Doubles item = (ParCoolConfig.Server.Doubles)context.getArgument(ARGS_NAME_CONFIG_ITEM, ParCoolConfig.Server.Doubles.class);
        double value = DoubleArgumentType.getDouble(context, (String)ARGS_NAME_VALUE);
        if (value < item.Min) {
            value = item.Min;
        }
        if (value > item.Max) {
            value = item.Max;
        }
        int num = 0;
        for (ServerPlayer player : targets) {
            Limitations.Changer.get(player).set(item, value).sync();
            ++num;
        }
        int finalNum = num;
        double finalValue = value;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"parcool.command.message.success.set", (Object[])new Object[]{finalNum, item.getPath(), Double.toString(finalValue)}), true);
        return 0;
    }

    private static int enableLimitation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS);
        int num = 0;
        for (ServerPlayer player : targets) {
            Limitations.Changer.get(player).setEnabled(true).sync();
            ++num;
        }
        int finalNum = num;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"parcool.command.message.success.enableLimitation", (Object[])new Object[]{finalNum}), true);
        return 0;
    }

    private static int disableLimitation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS);
        int num = 0;
        for (ServerPlayer player : targets) {
            Limitations.Changer.get(player).setEnabled(false).sync();
            ++num;
        }
        int finalNum = num;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"parcool.command.message.success.disableLimitation", (Object[])new Object[]{finalNum}), true);
        return 0;
    }

    private static int changeStaminaConsumption(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS);
        Class<? extends Action> action = ActionArgumentType.getAction(context, ARGS_NAME_ACTION);
        int newValue = IntegerArgumentType.getInteger(context, (String)ARGS_NAME_STAMINA_CONSUMPTION);
        int num = 0;
        for (ServerPlayer player : targets) {
            Limitations.Changer.get(player).setLeastStaminaConsumption(action, newValue).sync();
            ++num;
        }
        int finalNum = num;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"parcool.command.message.success.setStaminaConsumption", (Object[])new Object[]{finalNum, action.getSimpleName(), newValue}), true);
        return 0;
    }

    private static int changePossibilityOfAction(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection targets = EntityArgument.m_91477_(context, (String)ARGS_NAME_PLAYERS);
        Class<? extends Action> action = ActionArgumentType.getAction(context, ARGS_NAME_ACTION);
        boolean newValue = BoolArgumentType.getBool(context, (String)ARGS_NAME_POSSIBILITY);
        int num = 0;
        for (ServerPlayer player : targets) {
            Limitations.Changer.get(player).setPossibilityOf(action, newValue).sync();
            ++num;
        }
        int finalNum = num;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"parcool.command.message.success.setPermissionOfAction", (Object[])new Object[]{finalNum, action.getSimpleName(), newValue}), true);
        return 0;
    }
}

