/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.client.animation;

import com.alrex.parcool.utilities.MathUtil;
import com.alrex.parcool.utilities.VectorUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class PlayerModelRotator {
    private final PoseStack stack;
    private final Player player;
    private final float partial;
    private double playerHeight = 1.8;
    private boolean basedCenter = false;
    private boolean basedTop = false;

    public float getPartialTick() {
        return this.partial;
    }

    public PlayerModelRotator(PoseStack stack, Player player, float partial) {
        this.stack = stack;
        this.player = player;
        this.partial = partial;
        switch (player.m_20089_()) {
            case SWIMMING: 
            case CROUCHING: 
            case SLEEPING: {
                this.playerHeight = 0.6;
            }
        }
    }

    public PlayerModelRotator start() {
        return this;
    }

    public PlayerModelRotator startBasedCenter() {
        this.basedCenter = true;
        this.stack.m_85837_(0.0, this.playerHeight / 2.0, 0.0);
        return this;
    }

    public PlayerModelRotator startBasedTop() {
        this.basedTop = true;
        this.stack.m_85837_(0.0, this.playerHeight, 0.0);
        return this;
    }

    public PlayerModelRotator translateY(float offset) {
        this.stack.m_252880_(0.0f, offset, 0.0f);
        return this;
    }

    public PlayerModelRotator rotatePitchFrontward(float angleDegree) {
        Vec3 lookVec = this.player.m_7578_() ? VectorUtil.fromYawDegree(MathUtil.lerp(this.player.f_20884_, this.player.f_20883_, this.getPartialTick())).m_82524_(1.5707964f) : VectorUtil.fromYawDegree(this.player.f_20883_).m_82524_(1.5707964f);
        this.stack.m_252781_(Axis.m_253057_((Vector3f)lookVec.m_252839_()).m_252977_(angleDegree));
        return this;
    }

    public PlayerModelRotator rotateRollRightward(float angleDegree) {
        Vec3 lookVec = this.player.m_7578_() ? VectorUtil.fromYawDegree(MathUtil.lerp(this.player.f_20884_, this.player.f_20883_, this.getPartialTick())) : VectorUtil.fromYawDegree(this.player.f_20883_);
        Vector3f vec = new Vector3f((float)lookVec.m_7096_(), 0.0f, (float)lookVec.m_7094_());
        this.stack.m_252781_(Axis.m_253057_((Vector3f)lookVec.m_252839_()).m_252977_(angleDegree));
        return this;
    }

    public PlayerModelRotator rotateYawRightward(float angleDegree) {
        this.stack.m_252781_(Axis.f_252392_.m_252977_(angleDegree));
        return this;
    }

    public void end() {
        if (this.basedCenter) {
            this.stack.m_85837_(0.0, -this.playerHeight / 2.0, 0.0);
        }
        if (this.basedTop) {
            this.stack.m_85837_(0.0, -this.playerHeight, 0.0);
        }
    }

    public void endEnabledLegGrounding() {
        this.end();
    }
}

